unit fROR_ReportParams;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uROR_Selector, uROR_CustomControls, ExtCtrls, StdCtrls,
  ComCtrls, Buttons, uROR_ParamsPanel, fROR_VistARegistries, uROR_Reports,
  uROR_Utilities, Mask, o32flxed, o32editf, ovcbase, ovcef, ovcpb, ovcnf,
  ovcsf, o32rxvld, sablotengine, domimpl, ovcfiler,
  uROR_SelectorTree, ovcstate, uROR_State, uROR_CustomListView,
  uROR_GridView, uROR_ListView, uROR_AdvColGrid, ActnList, uROR_SearchEdit, uROR_DrugSelector,
  uROR_CustomSelector, VirtualTrees, uROR_SelectorGrid, ExeInfo, AdvPanel,
  AdvGrid, Grids, BaseGrid, AdvCGrid, uROR_ICD9Selector, o32vldtr, AdvObj;

type
  TGetFieldMode = (
    gfmDefault, { Load the lists only if they have been changed;
                  do not validate parameters. }

    gfmSave,    { Load all lists; do not validate parameters. }

    gfmRun      { Load all list; validate parameters and display
                  the error messages. }
  );

  TFrameReportParameters = class(TFrame)
    scbxMain: TScrollBox;
    pnlParams010: TCCRParamsPanel;
    pnlParams014: TCCRParamsPanel;
    pnlParams026: TCCRParamsPanel;
    cbInpatient: TCheckBox;
    cbOutpatient: TCheckBox;
    pnlParams022: TCCRParamsPanel;
    cbBefore: TCheckBox;
    cbDuring: TCheckBox;
    cbAfter: TCheckBox;
    pnlParams032: TCCRParamsPanel;
    cbCSSN: TCheckBox;
    cbLAST4: TCheckBox;
    cbSelRules: TCheckBox;
    cbDateSelected: TCheckBox;
    pnlParams028: TCCRParamsPanel;
    Bevel23: TBevel;
    cbVERAComplex: TCheckBox;
    cbVERABasic: TCheckBox;
    cbVERAPtList: TCheckBox;
    cbRegMedSMRY: TCheckBox;
    pnlParams060: TCCRParamsPanel;
    cbSeen: TCheckBox;
    cbNotSeen: TCheckBox;
    pnlParams020: TCCRParamsPanel;
    cbConfirmed: TCheckBox;
    cbPending: TCheckBox;
    pnlParams064: TCCRParamsPanel;
    pnlBottomSpacer: TCCRParamsPanel;
    pnlParams030: TCCRParamsPanel;
    cbRace: TCheckBox;
    cbRisk: TCheckBox;
    cbAge: TCheckBox;
    cbSex: TCheckBox;
    cbDateConf: TCheckBox;
    cbUtilization: TCheckBox;
    cbDateOfDeath: TCheckBox;
    pnlParams052: TCCRParamsPanel;
    rbLabTestsAll: TRadioButton;
    rbLabTestsSelected: TRadioButton;
    pnlLabTestSelector: TPanel;
    Bevel8: TBevel;
    ccrLabTestSelector: TCCRSelector;
    pnlParams058: TCCRParamsPanel;
    rbICD9All: TRadioButton;
    rbICD9Selected: TRadioButton;
    pnlICD9ListSelector: TPanel;
    Bevel7: TBevel;
    ccrICD9Selector: TCCRSelector;
    pnlParams050: TCCRParamsPanel;
    rbClinicsAll: TRadioButton;
    rbClinicsSelected: TRadioButton;
    pnlClinicListSelector: TPanel;
    Bevel6: TBevel;
    ccrClinicSelector: TCCRSelector;
    pnlParams034: TCCRParamsPanel;
    rbDivisionsAll: TRadioButton;
    rbDivisionsSelected: TRadioButton;
    pnlDivisionListSelector: TPanel;
    Bevel5: TBevel;
    ccrDivisionSelector: TCCRSelector;
    pnlParams110: TCCRParamsPanel;
    pnlParams046: TCCRParamsPanel;
    Label24: TLabel;
    edHighestUtilNum046: TO32FlexEdit;
    rbSummaryUsers: TRadioButton;
    rbDetailsUsers: TRadioButton;
    pnlParams120: TCCRParamsPanel;
    edMinRPNum120: TO32FlexEdit;
    edHighestUtilNum120: TO32FlexEdit;
    rbSummaryBoth: TRadioButton;
    rbDetailsBoth: TRadioButton;
    pnlParams056: TCCRParamsPanel;
    cbInvestigDrugs056: TCheckBox;
    pnlParams044: TCCRParamsPanel;
    rbGenericDrugs044: TRadioButton;
    rbDispensedDrugs044: TRadioButton;
    pnlParams042: TCCRParamsPanel;
    cbInvestigDrugs042: TCheckBox;
    cbRegistryDrugs042: TCheckBox;
    pnlParams140: TCCRParamsPanel;
    pnlPatientListSelector: TPanel;
    Bevel4: TBevel;
    ccrPatientSelector: TCCRSelector;
    pnlParams084: TCCRParamsPanel;
    pnlTopSpacer: TCCRParamsPanel;
    pnlParams054: TCCRParamsPanel;
    pnlDrugTreeSelector: TPanel;
    pnlDrugSearch054: TPanel;
    Bevel1: TBevel;
    cseDrugSearch: TCCRVistASearchEdit;
    vxsComponentState: TCCRComponentState;
    pnlDrugGroup: TPanel;
    edDrugGroupName: TEdit;
    spbDrugGroupAdd: TSpeedButton;
    cmbxDrugSearch054: TComboBox;
    pnlPatientSearch140: TPanel;
    csePatientSearch: TCCRVistASearchEdit;
    pnlDivisionSearch: TPanel;
    cseDivisionSearch: TCCRVistASearchEdit;
    pnlClinicSearch: TPanel;
    cseClinicSearch: TCCRVistASearchEdit;
    pnlICD9Search: TPanel;
    cseICD9Search: TCCRVistASearchEdit;
    pnlLabTestSearch: TPanel;
    cseLabTestSearch: TCCRVistASearchEdit;
    cmbbICD9Search: TComboBox;
    pnlParams059: TCCRParamsPanel;
    rbCPTAll: TRadioButton;
    rbCPTSelected: TRadioButton;
    Panel1: TPanel;
    Bevel9: TBevel;
    ccrCPTSelector: TCCRSelector;
    Panel2: TPanel;
    cseCPTSearch: TCCRVistASearchEdit;
    cmbbCPTSearch: TComboBox;
    pnlParams070: TCCRParamsPanel;
    Label4: TLabel;
    pnlParams100: TCCRParamsPanel;
    pnlParams130: TCCRParamsPanel;
    cgvSelectionRules: TCCRGridView;
    Label3: TLabel;
    cbDateSel: TCheckBox;
    cbSSN: TCheckBox;
    pnlParams035: TCCRParamsPanel;
    rbUTAll: TRadioButton;
    rbUTSelected: TRadioButton;
    cbUTAllergy: TCheckBox;
    cbUTCytopathology: TCheckBox;
    cbUTInpatient: TCheckBox;
    cbUTPharmacyIP: TCheckBox;
    cbUTPharmacyIV: TCheckBox;
    cbUTLaboratory: TCheckBox;
    cbUTMicrobiology: TCheckBox;
    cbUTOutpatient: TCheckBox;
    cbUTPharmacyOP: TCheckBox;
    cbUTRadiology: TCheckBox;
    cbUTSurgPath: TCheckBox;
    cbDateConfirmed: TCheckBox;
    cbDOD: TCheckBox;
    pnlParams047: TCCRParamsPanel;
    Label5: TLabel;
    pnlParams062: TCCRParamsPanel;
    rbComplete: TRadioButton;
    rbSummary: TRadioButton;
    cbDateOfBirth: TCheckBox;
    aclParams: TActionList;
    acCancelSearch: TAction;
    ccrDrugSelector: TCCRDrugSelector;
    rbDrugsSelected: TRadioButton;
    spbDrugGroupDelete: TSpeedButton;
    acDrugGroupDelete: TAction;
    acDrugGroupAdd: TAction;
    pnlParams011: TCCRParamsPanel;
    spbMin011: TSpeedButton;
    spbMax011: TSpeedButton;
    cmbxQuarter011: TComboBox;
    dtpFrom011: TDateTimePicker;
    dtpTo011: TDateTimePicker;
    cbFiscal011: TCheckBox;
    edCutOff011: TO32FlexEdit;
    edYear011: TO32FlexEdit;
    cbgPharmacy: TCCRCBGroup;
    cbgLab: TCCRCBGroup;
    pnlParams066: TCCRParamsPanel;
    cbCareOnly: TCheckBox;
    pnlParams053: TCCRParamsPanel;
    rbLTRAll: TRadioButton;
    rbLTRSelected: TRadioButton;
    Panel3: TPanel;
    Bevel2: TBevel;
    pnlLTRSearch: TPanel;
    cseLTRSearch: TCCRVistASearchEdit;
    ccrLTRSelector: TCCRSelectorGrid;
    pnlParams012: TCCRParamsPanel;
    spbMin012: TSpeedButton;
    spbMax012: TSpeedButton;
    cmbxQuarter012: TComboBox;
    dtpFrom012: TDateTimePicker;
    dtpTo012: TDateTimePicker;
    cbFiscal012: TCheckBox;
    edCutOff012: TO32FlexEdit;
    edYear012: TO32FlexEdit;
    pnlLabRanges: TPanel;
    agLabRanges: TCCRAdvColGrid;
    agLocalFields: TCCRAdvColGrid;
    agRegistries: TCCRAdvColGrid;
    pnlParams065: TCCRParamsPanel;
    rbRcvdProcedures: TRadioButton;
    rbDidNotRcvdProcedures: TRadioButton;
    rbPatientsSelected: TRadioButton;
    rbPatientsAll: TRadioButton;
    pnlParams150: TCCRParamsPanel;
    cbInpatient150: TCheckBox;
    cbOutpatient150: TCheckBox;
    pnlParams160: TCCRParamsPanel;
    pnlICD9Selector: TPanel;
    Bevel3: TBevel;
    pnlICD9Search160: TPanel;
    cseICD9Search160: TCCRVistASearchEdit;
    cmbxICD9Search160: TComboBox;
    ccrICD9Selector160: TCCRICD9Selector;
    rbAll160: TRadioButton;
    rbSelected160: TRadioButton;
    acICD9GroupDelete: TAction;
    acICD9GroupAdd: TAction;
    RegexValidator: TO32RegExValidator;
    rbLTRMostRecentAll: TRadioButton;
    rbLTRMostRecent: TRadioButton;
    pnlParams180: TCCRParamsPanel;
    pnlOtherDiagTemplateSelector: TPanel;
    Bevel10: TBevel;
    pnlOtherDiagSearch180: TPanel;
    cmbxOtherDiagSearch180: TComboBox;
    ccrOtherDiagSelector180: TCCRICD9Selector;
    rbIgnore180: TRadioButton;
    rbInclude180: TRadioButton;
    rbExclude180: TRadioButton;
    rbDrugsAll: TRadioButton;
    cbPendingComments: TCheckBox;
    btnAllRegistryMeds: TButton;
    acOtherDiagGroupDelete: TAction;
    pnlParams201: TCCRParamsPanel;
    rbRangeMostRecent: TRadioButton;
    rbRangeMax: TRadioButton;
    dtpRangeMaxDate: TDateTimePicker;
    Label6: TLabel;
    pnlLabels054: TPanel;
    pnlParams045: TCCRParamsPanel;
    rbOptionsAllFills: TRadioButton;
    rbOptionsMostRecent: TRadioButton;
    stxtAggregate044: TStaticText;
    pnlInstruct047: TPanel;
    stxtInstruct047: TStaticText;
    stxtSearch034: TStaticText;
    stxtSearch050: TStaticText;
    stxtSearch052: TStaticText;
    stxtSearch053: TStaticText;
    stxtSearchBy059: TStaticText;
    stxtSearch059: TStaticText;
    stxtSearch140: TStaticText;
    stxtGroupName054: TStaticText;
    stxtSearch054: TStaticText;
    stxtSearchBy054: TStaticText;
    stxtNumUsers120: TStaticText;
    stxtNumProcs120: TStaticText;
    lblSearchBy160: TLabel;
    stxtSearch160: TStaticText;
    stxtClinicsInstruct: TStaticText;
    stxtDivisionsInstruct: TStaticText;
    cbFirstDiag: TCheckBox;
    pnlAST: TPanel;
    stxtUpperLimitAST: TStaticText;
    edtUpperLimitAST047: TEdit;
    stxtLiverTests047: TStaticText;
    btnAllDivisions: TButton;
    lblType012: TLabel;
    cmbxDateType012: TComboBox;
    lblYear012: TLabel;
    lblQuarter012: TLabel;
    stxtQuarter012: TStaticText;
    lblType010: TLabel;
    cmbxDateType010: TComboBox;
    lblYear010: TLabel;
    edYear010: TO32FlexEdit;
    cbFiscal010: TCheckBox;
    lblQuarter010: TLabel;
    cmbxQuarter010: TComboBox;
    dtpFrom010: TDateTimePicker;
    spbMin010: TSpeedButton;
    dtpTo010: TDateTimePicker;
    spbMax010: TSpeedButton;
    edCutOff010: TO32FlexEdit;
    stxtQuarter010: TStaticText;
    lblType011: TLabel;
    cmbxDateType011: TComboBox;
    lblYear011: TLabel;
    lblQuarter011: TLabel;
    stxtQuarter011: TStaticText;
    cmbxSystem160: TComboBox;
    lblSystem160: TLabel;
    cmbxSystem059: TComboBox;
    stxtSystem059: TStaticText;
    pnlParams013: TCCRParamsPanel;
    lblType013: TLabel;
    lblYear013: TLabel;
    lblQuarter013: TLabel;
    spbMin013: TSpeedButton;
    spbMax013: TSpeedButton;
    cmbxDateType013: TComboBox;
    edYear013: TO32FlexEdit;
    cbFiscal013: TCheckBox;
    cmbxQuarter013: TComboBox;
    dtpFrom013: TDateTimePicker;
    dtpTo013: TDateTimePicker;
    edCutOff013: TO32FlexEdit;
    stxtQuarter013: TStaticText;
    cbConfirmAfter: TCheckBox;
    dtpConfirmAfter: TDateTimePicker;
    pnlParams090: TCCRParamsPanel;
    cbNaive: TCheckBox;
    cbExperienced: TCheckBox;
    edtTreatmentDays: TEdit;
    stxtTreatmentDays: TStaticText;
    pnlParams091: TCCRParamsPanel;
    lblWeeksAfterDAA: TLabel;
    edtWeeksAfterDAA: TEdit;
    cbPriorDAAStart: TCheckBox;
    stxtWeeksAfterDAA: TStaticText;
    stxtTreatmentExclude: TStaticText;
    pnlTreatment090: TPanel;
    stxtTreatmentWarning1: TStaticText;
    stxtTreatmentWarning: TStaticText;
    btnDateRangeHelp010: TButton;
    btnDateRangeHelp011: TButton;
    btnDateRangeHelp012: TButton;
    pnlSched014_1: TPanel;
    stxtDay014: TStaticText;
    dtpScheduleDay: TDateTimePicker;
    stxtAt014: TStaticText;
    dtpScheduleTime: TDateTimePicker;
    stxtRepeat014: TStaticText;
    cmbbSchedule: TComboBox;
    pnlSched014_2: TPanel;
    stxtComment014: TStaticText;
    edTaskComment: TEdit;
    pnlLanding: TPanel;
    stxtLanding: TStaticText;
    pnlParams023: TCCRParamsPanel;
    rbSexBoth: TRadioButton;
    rbSexFemale: TRadioButton;
    rbSexMale: TRadioButton;
    pnlParams024: TCCRParamsPanel;
    cbICN: TCheckBox;
    pnlICDGroupAlign160: TPanel;
    pnlICD9Group160: TPanel;
    spbICD9GroupAdd: TSpeedButton;
    spbICD9GroupDelete: TSpeedButton;
    edICD9GroupName: TEdit;
    stxtGroupName160: TStaticText;
    pnlParams025: TCCRParamsPanel;
    rbOEFAll: TRadioButton;
    rbOEFInclude: TRadioButton;
    rbOEFExclude: TRadioButton;
    procedure pnlParams010SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams010GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams022SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams022GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams020GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams020SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams026GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams026SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams032GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams032SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams028GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams028SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams060GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams060SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams064GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams064SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams030GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams030SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams042GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams042SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams044GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams044SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams056GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams056SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams120GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams120SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure rbSummaryBothClick(Sender: TObject);
    procedure rbDetailsBothClick(Sender: TObject);
    procedure pnlParams046GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams046SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure rbSummaryUsersClick(Sender: TObject);
    procedure rbDetailsUsersClick(Sender: TObject);
    procedure pnlParams014GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams014SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams052GetValues(const aReportCode: String; aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams052SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure cseLabTestSearchSearchStart(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure pnlParams058GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams058SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure cseSearch(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure cseSearchEnd(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure pnlParams059GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams059SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure cseCPTSearchSearchStart(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure ccrCPTSelectorSplitterMoved(Sender: TObject);

    procedure pnlParams050GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams050SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure cseClinicSearchSearchStart(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure cseDivisionSearchSearchStart(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure pnlParams034GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams034SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure rbAllClick(Sender: TObject);
    procedure rbSelectedClick(Sender: TObject);
    procedure pnlParams140GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams140SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure csePatientSearchSearchStart(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure ccrDrugSelectorSplitterMoved(Sender: TObject);
    procedure pnlDrugGroupResize(Sender: TObject);
    procedure pnlParams054SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams054GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure cseDrugSearchSearchStart(aSender: TObject; var aCommand: TCCRSearchCommand);
    procedure ccrPatientSelectorSplitterMoved(Sender: TObject);
    procedure ccrDivisionSelectorSplitterMoved(Sender: TObject);
    procedure ccrClinicSelectorSplitterMoved(Sender: TObject);
    procedure ccrICD9SelectorSplitterMoved(Sender: TObject);
    procedure ccrLabTestSelectorSplitterMoved(Sender: TObject);
    procedure pnlParams070SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams070GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams100GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams100SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams130GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams130SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams047Setup(const aReportCode: string);
    procedure pnlParams047GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams047SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams062GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams062SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure pnlParams035GetValues(const aReportCode: String; aList: TCustomReportParameters;
      aMsgLst: TStrings; var aField: TWinControl);
    procedure pnlParams035SetValues(const aReportCode: String; aList: TCustomReportParameters);
    procedure agLabRangesCheckBoxClick(Sender: TObject; ACol,
      ARow: Integer; State: Boolean);
    procedure agRangesSetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: String);
    procedure acCancelSearchExecute(Sender: TObject);
    procedure cseICD9SearchSearchStart(aSender: TObject;
      var aCommand: TCCRSearchCommand);
    procedure cmbxDrugSearch054Select(Sender: TObject);
    procedure acDrugGroupDeleteExecute(Sender: TObject);
    procedure acDrugGroupAddExecute(Sender: TObject);
    procedure ccrDrugSelectorResultListKeyAction(
      Sender: TBaseVirtualTree; var CharCode: Word; var Shift: TShiftState;
      var DoDefault: Boolean);
    procedure edDrugGroupNameKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pnlParams054Setup(const aReportCode: String);
    procedure pnlParams010Setup(const aReportCode: String);
    procedure pnlParams011GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams011SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure spbMin011Click(Sender: TObject);
    procedure spbMax011Click(Sender: TObject);
    procedure pnlParams052Setup(const aReportCode: String);
    procedure cbgPharmacyChange(Sender: TObject);
    procedure cbgLabChange(Sender: TObject);
    procedure pnlParams066GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams066SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure cseLTRSearchSearchStart(aSender: TObject;
      var aCommand: TCCRSearchCommand);
    procedure pnlParams053GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams053Setup(const aReportCode: String);
    procedure pnlParams053SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure ccrLTRSelectorSplitterMoved(Sender: TObject);
    procedure ccrLTRSelectorResultListGetDisplText(Sender: TObject; ACol,
      ARow: Integer; var Value: String);
    procedure ccrLTRSelectorResultListCanEditCell(Sender: TObject; ARow,
      ACol: Integer; var CanEdit: Boolean);
    procedure ccrLTRSelectorResultListCustomCompare(Sender: TObject; str1,
      str2: String; var Res: Integer);
    procedure spbMin012Click(Sender: TObject);
    procedure spbMax012Click(Sender: TObject);
    procedure pnlParams012GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams012SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure cbCareOnlyClick(Sender: TObject);
    procedure pnlParams011ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams012ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams010ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams052ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams053ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams054ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams044ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure vxsComponentStateRestoreState(Sender: TObject);
    procedure vxsComponentStateSaveState(Sender: TObject);
    procedure agRegistriesCellChanging(Sender: TObject; OldRow, OldCol,
      NewRow, NewCol: Integer; var Allow: Boolean);
    procedure agLocalFieldsCellChanging(Sender: TObject; OldRow, OldCol,
      NewRow, NewCol: Integer; var Allow: Boolean);
    procedure pnlParams065GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams065SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure rbPatientsAllClick(Sender: TObject);
    procedure rbPatientsSelectedClick(Sender: TObject);
    procedure pnlParams150GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams150SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure cbInpatient150Click(Sender: TObject);
    procedure cbOutpatient150Click(Sender: TObject);
    procedure pnlParams160ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams160GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams160SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure cseICD9Search160SearchStart(aSender: TObject;
      var aCommand: TCCRSearchCommand);
    procedure pnlICD9Group160Resize(Sender: TObject);
    procedure edICD9GroupNameKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pnlParams160Setup(const aReportCode: String);
    procedure ccrICD9Selector160SplitterMoved(Sender: TObject);
    procedure acICD9GroupDeleteExecute(Sender: TObject);
    procedure acICD9GroupAddExecute(Sender: TObject);
    procedure ccrICD9Selector160ResultListKeyAction(
      Sender: TBaseVirtualTree; var CharCode: Word; var Shift: TShiftState;
      var DoDefault: Boolean);
    procedure pnlParams053ConstrainedResize(Sender: TObject; var MinWidth,
      MinHeight, MaxWidth, MaxHeight: Integer);
    procedure rbLTRAllClick(Sender: TObject);
    procedure pnlParams180ClearParams(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure pnlParams180GetValues(const aReportCode: String;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams180Setup(const aReportCode: String);
    procedure pnlParams180SetValues(const aReportCode: String;
      aList: TCustomReportParameters);
    procedure cmbxOtherDiagSearch180Select(Sender: TObject);
    procedure rbIgnore180Click(Sender: TObject);
    procedure ccrOtherDiagSelector180Add(Sender: TObject);
    procedure ccrDrugSelectorAdd(Sender: TObject);
    procedure ccrDrugSelectorAddAll(Sender: TObject);
    procedure ccrOtherDiagSelector180AddAll(Sender: TObject);
    procedure cbPendingClick(Sender: TObject);
    procedure btnAllRegistryMedsClick(Sender: TObject);
    procedure rbDrugsSelectedClick(Sender: TObject);
    procedure rbDrugsAllClick(Sender: TObject);
    procedure ccrOtherDiagSelector180RemoveAll(Sender: TObject);
    procedure ccrOtherDiagSelector180Remove(Sender: TObject);
    procedure ccrOtherDiagSelector180ResultListKeyAction(
      Sender: TBaseVirtualTree; var CharCode: Word; var Shift: TShiftState;
      var DoDefault: Boolean);
    procedure acOtherDiagGroupDeleteExecute(Sender: TObject);
    procedure pnlParams201GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams201SetValues(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure pnlParams201Setup(const aReportCode: string);
    procedure rbToggleDateEntry(Sender: TObject);
    procedure pnlParams045GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams045SetValues(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure rbDivisionsAllClick(Sender: TObject);
    procedure rbDivisionsSelectedClick(Sender: TObject);
    procedure rbClinicsAllClick(Sender: TObject);
    procedure rbClinicsSelectedClick(Sender: TObject);
    procedure pnlParams011Setup(const aReportCode: string);
    procedure pnlParams012Setup(const aReportCode: string);
    procedure pnlParams044Setup(const aReportCode: string);
    procedure pnlParams034Setup(const aReportCode: string);
    procedure pnlParams050Setup(const aReportCode: string);
    procedure pnlParams140Setup(const aReportCode: string);
    procedure pnlParams120Setup(const aReportCode: string);
    procedure ccrLTRSelectorResultListColumnSize(Sender: TObject; ACol: Integer;
      var Allow: Boolean);
    procedure pnlParams066Setup(const aReportCode: string);
    procedure pnlParams032Setup(const aReportCode: string);
    procedure edtUpperLimitAST047KeyPress(Sender: TObject; var Key: Char);
    procedure btnAllDivisionsClick(Sender: TObject);
    procedure cmbxDateType012Change(Sender: TObject);
    procedure cmbxDateType010Change(Sender: TObject);
    procedure spbMin010Click(Sender: TObject);
    procedure spbMax010Click(Sender: TObject);
    procedure cmbxDateType011Change(Sender: TObject);
    procedure cmbxDateType013Change(Sender: TObject);
    procedure spbMin013Click(Sender: TObject);
    procedure spbMax013Click(Sender: TObject);
    procedure pnlParams013ClearParams(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure pnlParams013Setup(const aReportCode: string);
    procedure pnlParams013GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams013SetValues(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure cbConfirmAfterClick(Sender: TObject);
    procedure cbConfirmedClick(Sender: TObject);
    procedure pnlParams090SetValues(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure pnlParams090GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure cbExperiencedClick(Sender: TObject);
    procedure edtTreatmentDaysKeyPress(Sender: TObject; var Key: Char);
    procedure edtWeeksAfterDAAKeyPress(Sender: TObject; var Key: Char);
    procedure pnlParams091GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams091SetValues(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure pnlParams091Setup(const aReportCode: string);
    procedure pnlParams090Setup(const aReportCode: string);
    procedure pnlParams020Setup(const aReportCode: string);
    procedure DisplayDateRangeHelp(Sender: TObject);
    procedure agLabRangesEnter(Sender: TObject);   // Patch 20
    procedure setupUpperLimit(aState: boolean);    // Patch 20
    procedure agRegistriesEnter(Sender: TObject);  // Patch 21
    procedure agLocalFieldsEnter(Sender: TObject);
    procedure pnlParams023GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams023SetValues(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure pnlParams024SetValues(const aReportCode: string;
      aList: TCustomReportParameters);
    procedure pnlParams024GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams025GetValues(const aReportCode: string;
      aList: TCustomReportParameters; aMsgLst: TStrings;
      var aField: TWinControl);
    procedure pnlParams025SetValues(const aReportCode: string;
      aList: TCustomReportParameters); // Patch 21

  private
    fCurrentReport: String;
    { If fFullUpdate is True, the GetFieldValues retrieves values from all
      controls. Otherwise, some unchanged lists will not be retrieved. }
    fFullUpdate: Boolean;

    { References to the nodes that are checked/updated most often }
    fNodeDrugs:    TDomNode;
    fNodeColumns:  TDomNode;
    fNodeOptions:  TDomNode;
    fNodePatients: TDomNode;

    { fRegInfo stores a reference to the registry descriptor }
    fRegInfo: TRegistryInfo;

    { References to lists of lab tests }
    fRegTests:    TStringList;
    fBMITests:    TStringList;
    fLiverTests:  TStringList;
    fRenalTests:  TStringList;

    function  getColumnOption(const aName: String): Boolean;
    procedure setColumnOption(const aName: String; aValue: Boolean);
    procedure setRegInfo(aRegInfo: TRegistryInfo);
    function  getICD9Filter: String;
    function  getICD9FilterType: String;
    procedure loadOtherDiagList;

  protected
    procedure CreateWnd; override;
    function isCutOffValid(const aText: String): Boolean;
    function  validateScheduleCode(const aCode: String;
      const aDateTime: TDateTime): Boolean;

    property FullUpdate: Boolean        read  fFullUpdate;

    property NodeDrugs: TDomNode        read  fNodeDrugs;
    property NodeColumns: TDomNode      read  fNodeColumns;
    property NodeOptions: TDomNode      read  fNodeOptions;
    property NodePatients: TDomNode     read  fNodePatients;
    property ICD9Filter: String         read  getICD9Filter;
    property ICD9FilterType: String     read  getICD9FilterType;

  public
    constructor Create(anOwner: TComponent); override;

    function  GetDTRun: TDateTime;
    function  GetFieldValues(const aReportCode: String;
      ReportParams: TReportParameters; aMode: TGetFieldMode = gfmDefault): TWinControl;
    procedure SetFieldValues(const aReportCode: String;
      ReportParams: TReportParameters);
    procedure SetupPanels(aReport: TReportDescriptor);
    procedure UpdatePanelReferences;

    property RegInfo: TRegistryInfo     read  fRegInfo
                                        write setRegInfo;

  end;

implementation
{$R *.dfm}

uses
  StrUtils, uROR_Common, uROR_CommonUtils, uROR_Broker, uROR_CustomBroker, DateUtils,
  fROR_ReportSelector, uROR_Strings, sdom, fROR_Options, uROR_Classes,
  fROR_ResultRanges, fROR_OtherRegistries, fROR_LocalFields, // Patch 20 and 21
  uROR_TemplateFormatFix // ROR*1.5*19 Format Fix
  ;

const
  dtrsCustom  = 'CUSTOM';
  dtrsCutOff  = 'CUTOFF';
  dtrsEnd     = 'END';
  dtrsFiscal  = 'FISCAL';
  dtrsQuarter = 'QUARTER';
  dtrsStart   = 'START';
  dtrsType    = 'TYPE';
  dtrsYear    = 'YEAR';

  dirNone   = 0;
  dirCommon = 1;
  dirUser   = 2;

  iName  = 0;
  iIEN   = 1;
  iDescr = 2;

  lfMode     = 0;
  lfName     = 1;
  lfDescr    = 2;
  lfIEN      = 3;

  lrgToggle    = 0;
  lrgGroupName = 1;
  lrgLow       = 2;
  lrgHigh      = 3;
  lrgGroupCode = 4;

  //-- Section 508: Added Dummy508 as the first column
  ltrDummy508 = 0;
  ltrName     = 1;
  ltrPanel    = 2;
  ltrLow      = 3;
  ltrHigh     = 4;
  ltrIEN      = 5;

  orMode     = 0;
  orDescr    = 1;
  orName     = 2;
  orIEN      = 3;

  ssClinicSelector   = 'ClinicSelector';
  ssCPTSelector      = 'CPTSelector';
  ssDivisionSelector = 'DivisionSelector';
  ssDrugSelector     = 'DrugSelector';
  ssICD9Selector     = 'ICD9Selector';
  ssLabRanges        = 'LabRanges';
  ssLabTestSelector  = 'LabTestSelector';
  ssLocalFields      = 'LocalFields';
  ssLTRSelector      = 'LTRSelector';
  ssPatientSelector  = 'PatientSelector';
  ssRegistries       = 'Registries';

function checkRange(const aLow, aHigh: String): Boolean;
begin
  Result := (StrToFloatDef(aLow,0) <= StrToFloatDef(aHigh,0)) or
            (aLow = '') or (aHigh = '');
end;

//***** LOADS THE RESULT LIST OF THE SELECTOR

procedure loadSelectorResult(aSelector: TCCRSelector; aList: TDomNode;
  anAttrList: array of String);
var
  i: Integer;
  node, txtNode: TDomNode;
begin
  with aSelector.ResultList.Items do
    begin
      BeginUpdate;
      try
        //--- Clear both lists of the selector
        aSelector.Clear;
        if Assigned(aList) then
          begin
            //--- Load the result list from the report parameters
            node := aList.FirstChild;
            while node <> nil do
              begin
                if node.NodeType = SDOM_ELEMENT_NODE then
                  with Add do
                    begin
                      for i:=0 to High(anAttrList) do
                        if anAttrList[i] = '*' then
                          begin
                            txtNode := node.FindNode('text()');
                            if txtNode <> nil then
                              AsString[i] := txtNode.NodeValue;
                          end
                        else if anAttrList[i] <> '' then
                          AsString[i] := node.getAttribute(anAttrList[i]);
                    end;
                node := node.NextSibling;
              end;
          end;
      finally
        EndUpdate;
      end;
    end;
  aSelector.ResultChanged := False;
end;

procedure loadSelectorGridResult(aSelector: TCCRSelectorGrid; aList: TDomNode;
  anAttrList: array of String);
var
  i, cr: Integer;
  node, txtNode: TDomNode;
begin
  with aSelector.ResultList do
    begin
      BeginUpdate;
      try
        //--- Clear both lists of the selector
        aSelector.Clear;
        if Assigned(aList) then
          begin
            //--- Load the result list from the report parameters
            node := aList.FirstChild;
            while node <> nil do
              begin
                if node.NodeType = SDOM_ELEMENT_NODE then
                  begin
                    AddRow;
                    cr := RealRowIndex(RowCount - 1);
                    for i:=0 to High(anAttrList) do
                      if anAttrList[i] = '*' then
                        begin
                          txtNode := node.FindNode('text()');
                          if txtNode <> nil then
                            AllCells[i,cr] := txtNode.NodeValue;
                        end
                      else if anAttrList[i] <> '' then
                        AllCells[i,cr] := node.getAttribute(anAttrList[i]);
                  end;
                node := node.NextSibling;
              end;
          end;
      finally
        EndUpdate;
      end;
    end;
  aSelector.ResultChanged := False;
end;

procedure deleteResultTreeGroup(aTree: TCCRICD9SelectorTree);
var
  next, node: PVirtualNode;
  rc: Word;
begin
  with aTree do
    begin
      rc := mrNo;
      next := GetFirstChild(RootNode);
      while Assigned(next) do
        begin
          node := next;
          next := GetNextSibling(node);
          if Selected[node] then
            begin
              if rc <> mrYesToAll then
                begin
                  // DEBUG(ETM) - was MessageDialog (default = mrNo)
                  rc := MessageDlg508(rscReportParameters,
                          Format(RSC00223,[AsString[node,idscName]]),
                          mtConfirmation, [mbYes,mbNo,mbYesToAll,mbCancel], 0);
                  if rc = mrCancel then
                    Break;
                end;
              if (rc = mrYesToAll) or (rc = mrYes) then
                DeleteGroup(node);
            end;
        end;
    end;
end;

//***** LOADS THE RESULT RANGE GRID WITH A LIST OF TESTS

procedure loadResultRangeGrid(aGrid: TCCRAdvColGrid; aList: TStringList;
  aHeader: string; bSetHeight: boolean = false);
begin
  with aGrid do
  begin
    RemoveAll;
    AssignRawData(aList, [-1,2,-1,-1,3]);
    SortSettings.Column := lrgGroupName;
    SortSettings.Direction := AdvGrid.sdAscending;
    QSort;
    ColumnHeaders[1] := aHeader;
    if bSetHeight then
    begin
      if aList.Count < 5 then
        Height := 25 + (aList.Count * 21)
      else
        Height := 25 + (5 * 21);
    end;
  end;
end;

//////////////////////////// TFrameReportParameters \\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TFrameReportParameters.Create(anOwner: TComponent);
var
  dtn: TDateTime;
begin
  inherited;
  agLabRanges.HideColumn(lrgGroupCode);
  agLocalFields.HideColumn(lfIEN);;
  agLocalFields.AutoSizeCol(lfMode);
  dtn := GetServerDateTime();
  dtpScheduleDay.DateTime  := DateOf(dtn);
  dtpScheduleTime.DateTime := TimeOf(dtn);

  with agRegistries do
  begin
    AutoSizeCol(orMode);
  end;

  with ccrDrugSelector do
  begin
    cseDrugSearch.SearchGrid := SourceList;
    SourceList.Fields[idscDrugCode].Visible := False;
    SourceType := idstGeneric;
  end;

  with ccrLTRSelector do
  begin
    Clear;
    ResultList.HideColumn(ltrIEN);
    cseLTRSearch.SearchGrid := SourceList;
  end;

  with ccrICD9Selector160 do
  begin
    cseICD9Search160.SearchGrid := SourceList;
  end;
end;

//*****

procedure TFrameReportParameters.acCancelSearchExecute(Sender: TObject);
begin
  cseClinicSearch.CancelSearch;
  cseCPTSearch.CancelSearch;
  cseDivisionSearch.CancelSearch;
  cseICD9Search.CancelSearch;
  cseICD9Search160.CancelSearch;
  cseLabTestSearch.CancelSearch;
  cseLTRSearch.CancelSearch;
  csePatientSearch.CancelSearch;
end;

//*****

procedure TFrameReportParameters.CreateWnd;
begin
  inherited;
  AccAnnotate(Self);
end;

//*****

function TFrameReportParameters.getICD9Filter: String;
begin
  if rbInclude180.Checked then
    Result := 'INCLUDE'
  else if rbExclude180.Checked then
    Result := 'EXCLUDE'
  else
    Result := 'ALL';
end;

//*****

function TFrameReportParameters.getICD9FilterType: String;
begin
  if cmbxOtherDiagSearch180.ItemIndex = dirCommon then
    Result := 'PKG'
  else if cmbxOtherDiagSearch180.ItemIndex = dirUser then
    Result := 'USR';
end;

//*****

procedure TFrameReportParameters.cseSearch(
  aSender: TObject; var aCommand: TCCRSearchCommand);
var
  n: Integer;
  searchFrom: String;
begin

  with TCCRVistASearchEdit(aSender) do
    if Broker.CallProc(SearchRPCName, SearchParams, nil, RawData) then
    begin
      //--- Check number of loaded records
      n := StrToIntDef(Piece(RawData[0],U), 0);
      searchFrom := Piece(RawData[0], U, 2, 99);
      if n > 0 then
      begin
        Inc(SearchCount, n);
        //--- Add the records to the list
        RawData.Delete(0);
        // ICD-10 Remediation. ROR*1.5*19 2012-01-09 adding System info =====[
        //SearchGrid.Items.AppendRawData(RawData, SearchFieldsArray, U, SearchStrPerItem);
        SearchGrid.Items.AppendRawDataDef(RawData, SearchFieldsArray, U,
          SearchStrPerItem, cmbxSystem160.Text,-99);
        // ICD-10 Remediation. ROR*1.5*19 2012-01-09 adding System info =====]
        //--- Check if the maximum number of records has been reached
        if (SearchMaxCount > 0) and (SearchCount >= SearchMaxCount) then
          aCommand := cscFinish;
      end;
      //--- Check if there are more records to load
      if SearchFromIndex >= 0 then
      begin
        SearchParams[SearchFromIndex] := searchFrom;
        if searchFrom = '' then
          aCommand := cscFinish;
      end
      else
        aCommand := cscFinish;
    end
    else
      aCommand := cscCancel;
end;

//*****

procedure TFrameReportParameters.cseSearchEnd(aSender: TObject;
  var aCommand: TCCRSearchCommand);
  {$IFDEF DBUGETM5}
var
  DebugETM: TextFile;
  DebugETMisTrue: boolean;
  iETM: integer;
  gi: TCCRGridItem;
  {$ENDIF}
begin
  with TCCRVistASearchEdit(aSender) do
    begin
      //--- Display a warning if not all records have been loaded
      if (SearchMaxCount > 0) and (SearchCount > SearchMaxCount) then
        MessageDlg508('', rscSearchTooMany, mtInformation, [mbOK], 0);

      //--- Display a warning if no records have been found.
      //    Otherwise, move focus to the list.
      if SearchGrid.Items.Count > 0 then
      begin
        {$IFDEF DBUGETM5}
          //--- Write out ICD search results
          DebugETMisTrue := FileExists('C:\ETM\DEBUG-ETM-5.txt');
          if DebugETMisTrue then
          begin
            System.AssignFile(DebugETM, 'C:\ETM\DEBUG-ETM-5.txt');
            System.Append(DebugETM);
            writeln(DebugETM, '********* Results for ' + cseICD9Search160.Text
              + ' *********');
            for iETM := 0 to SearchGrid.Items.Count-1 do
            begin
              gi := SearchGrid.Items.Item[iETM];
              writeln(DebugETM, gi.AsString[2] + ' = ' + gi.AsString[1]);
            end;
            writeln(DebugETM, '*************** End of List ***************');
            System.CloseFile(DebugETM);
          end;
        {$ENDIF}
        SearchGrid.AlphaSort;
        SearchGrid.SetFocus;
      end
      else
        MessageDlg508('', rscSearchNone, mtInformation, [mbOK], 0);
    end;
end;

//*****

function TFrameReportParameters.getColumnOption(const aName: String): Boolean;
begin
  if Assigned(NodeColumns) then
    Result := (NodeColumns.FindNode('COLUMN[@ID="'+aName+'"]') <> nil)
  else
    Result := False;
end;

//***** COMBINES DATE AND TIME FROM THE SCHEDULE CONTROLS

function TFrameReportParameters.GetDTRun: TDateTime;
begin
  Result := Trunc(dtpScheduleDay.Date) + dtpScheduleTime.Time -
    Trunc(dtpScheduleTime.Time);
end;

//***** UPDATES THE REPORT PARAMETERS WITH CURRENT VALUES OF VISIBLE CONTROLS

function TFrameReportParameters.GetFieldValues(const aReportCode: String;
  ReportParams: TReportParameters; aMode: TGetFieldMode): TWinControl;
var
  i, iCtrl, lastCtrl, n: Integer;
  ctrl: TWinControl;
  messageList, msgLst: TStringList;
  msg, panelCaption, prevCaption: String;
  group: TDomNode;
begin
  Result := nil;
  panelCaption := '';
  prevCaption  := '';
  fFullUpdate := (aMode <> gfmDefault);
  messageList := TStringList.Create;
  msgLst := TStringList.Create;

  try
    with scbxMain do
      begin
        //--- Find common nodes (create if necessary)
        with ReportParams do
          begin
            fNodeDrugs    := GetNode('/PARAMS/DRUGS');
            fNodeColumns  := GetNode('/PARAMS/OPTIONAL_COLUMNS');
            fNodeOptions  := GetNode('/PARAMS/OPTIONS');
            fNodePatients := GetNode('/PARAMS/PATIENTS');
          end;

        //--- Special processing to clear the Divisions on the Clinics, CML and
        //--- Procedures reports
        if (aReportCode = '4') or (aReportCode = '12') or (aReportCode = '15') then
        begin
          if rbDivisionsAll.Checked then
          begin
            group := ReportParams.GetNode('/PARAMS/DIVISIONS');
            ReportParams.SetAttrVal(group, 'ALL', True);
            ReportParams.DeleteChildren(group);
          end;
        end;

        //--- Get the parameter values and validate them
        lastCtrl := ControlCount - 1;
        for iCtrl:=0 to lastCtrl do
          if (Controls[iCtrl] is TCCRParamsPanel) and Controls[iCtrl].Visible then
            begin
              with TCCRParamsPanel(Controls[iCtrl]) do
                if Caption <> '' then
                  panelCaption := Caption;
              msgLst.Clear;

              //--- Get parameter values from the panel
              ctrl := TCCRParamsPanel(Controls[iCtrl]).GetFieldValues(
                aReportCode, ReportParams, msgLst);

              //--- Collect the error messages if the errors have been
              //    encountered and parameter validation is requested
              if Assigned(ctrl) and (aMode = gfmRun) then
                begin
                  //--- Remember the first erroneous control
                  if not Assigned(Result) then
                    Result := ctrl;
                  //--- Add the panel caption as a heading
                  if (panelCaption <> '') and (panelCaption <> prevCaption) then
                    begin
                      messageList.Add('');
                      messageList.Add(panelCaption);
                      prevCaption := panelCaption;
                    end;
                  //--- Append the panel messages to the message list
                  n := msgLst.Count - 1;
                  for i:=0 to n do
                    messageList.Add(#9 + msgLst[i]);
                end;
            end;
      end;

    if Assigned(Result) then
      begin
        //--- Otherwise, display the error messages
        msg := RSC00200;
        if messageList.Count > 0 then
          msg := msg + ': ' + #13
        else
          msg := msg + '.';
        MessageDlg508('', msg + messageList.Text, mtError, [mbOK], 0);
      end;

  finally
    //--- Always free the temporary buffers
    msgLst.Free;
    messageList.Free;
  end;
end;

function TFrameReportParameters.isCutOffValid(const aText: String): Boolean;
begin
  with RegexValidator do
    begin
      Mask := '(T(ODAY)?)?(\-)?[0-9]+[DMW]?';
      Input := aText;
      Result := IsValid;
    end;
end;

//***** Display message regarding large date ranges

procedure TFrameReportParameters.DisplayDateRangeHelp(Sender: TObject);
begin
  MessageDlg508('', RSC00400, mtInformation, [mbok], 0);
end;

//***** DISABLE PANEL CONTROLS IF THE 'INCLUDE ALL' RADIO-BUTTON IS SELECTED

procedure TFrameReportParameters.rbAllClick(Sender: TObject);
  procedure rb_all(ctrl: TWinControl);
  var
    i: Integer;
  begin
    with ctrl do
      for i:=ControlCount-1 downto 0 do
        begin
          if Controls[i] is TCCRAdvColGrid then
            Controls[i].Enabled := False
          else if Controls[i] is TCCRCustomSelector then
          begin
            TCCRCustomSelector(Controls[i]).Clear;
            Controls[i].Enabled := False;
            if Controls[i] is TCCRSelectorGrid then
              TCCRSelectorGrid(Controls[i]).ResultList.Color := CtrlColor(False);
          end
          else if Controls[i] is TCCRSearchEdit then
            begin
              TCCRSearchEdit(Controls[i]).Text := '';
              Controls[i].Enabled := False;
            end
          else if Controls[i] is TComboBox then
            begin
              TComboBox(Controls[i]).Color := CtrlColor(False);
              Controls[i].Enabled := False;
            end
          else if Controls[i] is TCheckBox then
            Controls[i].Enabled := False
          else if Controls[i] is TEdit then
            begin
              TEdit(Controls[i]).Color := CtrlColor(False);
              Controls[i].Enabled := False;
            end
          else if Controls[i] is TPanel then
            Controls[i].Enabled := False;
          //--- Recursively search for child controls
          if Controls[i] is TWinControl then
            rb_all(TWinControl(Controls[i]));
        end;
  end;
begin
  with TWinControl(Sender) do
    if Assigned(Parent) then
      rb_all(Parent);
end;

procedure TFrameReportParameters.rbLTRAllClick(Sender: TObject);
begin
  rbAllClick(Sender);
  // Enable the 'most recent' lab test radio buttons
  panel3.Enabled := True;
  pnlLTRSearch.Enabled := True;
  rbLTRMostRecentAll.Enabled := True;
  rbLTRMostRecent.Enabled := True;
end;

//***** ENABLE PANEL CONTROLS IF THE 'SELECTED ONLY' RADIO-BUTTON IS SELECTED

procedure TFrameReportParameters.rbSelectedClick(Sender: TObject);
  procedure rb_selected(ctrl: TWinControl);
  var
    i: Integer;
  begin
    with ctrl do
      for i:=ControlCount-1 downto 0 do
        begin
          if Controls[i] is TCCRAdvColGrid then
            Controls[i].Enabled := True
          else if Controls[i] is TCCRCustomSelector then
          begin
            Controls[i].Enabled := True;
            if Controls[i] is TCCRSelectorGrid then
              TCCRSelectorGrid(Controls[i]).ResultList.Color := CtrlColor(True);
          end
          else if Controls[i] is TCCRSearchEdit then
            Controls[i].Enabled := True
          else if Controls[i] is TComboBox then
            begin
              TComboBox(Controls[i]).Color := CtrlColor(True);
              Controls[i].Enabled := True;
            end
          else if Controls[i] is TCheckBox then
            Controls[i].Enabled := True
          else if Controls[i] is TEdit then
            begin
              TEdit(Controls[i]).Color := CtrlColor(True);
              Controls[i].Enabled := True;
            end
          else if Controls[i] is TPanel then
            Controls[i].Enabled := True;
          //--- Recursively search for child controls
          if Controls[i] is TWinControl then
            rb_selected(TWinControl(Controls[i]));
        end;
  end;
begin
  with TWinControl(Sender) do
    if Assigned(Parent) then
      rb_selected(Parent);
end;

//*****

procedure TFrameReportParameters.setColumnOption(const aName: String; aValue: Boolean);
  var
    node: TDomNode;
begin
  with NodeColumns.OwnerDocument do
    begin
      node := NodeColumns.FindNode('COLUMN[@ID="'+aName+'"]');
      if aValue and (node = nil) then
        begin
          node := NodeColumns.appendChild(CreateElement('COLUMN'));
          node.setAttribute('ID', aName);
        end
      else if not aValue and (node <> nil) then
        begin
          NodeColumns.removeChild(node);
          DisposeNode(node);
        end;
    end;
end;

//*****

procedure TFrameReportParameters.setRegInfo(aRegInfo: TRegistryInfo);
var
  i, rri: Integer;
  ri: TRegistryInfo;
  rawData: TStringList;
  oldParams: TReportParameters;
begin
  if aRegInfo <> fRegInfo then
    begin
      //--- Store the registry descriptor reference
      fRegInfo := aRegInfo;

      //--- Populate the list of registries for the 'Other Registries' panel
      agRegistries.BeginUpdate;
      try
        agRegistries.RemoveAll;
        //--- Unhide columns so that the proper IEN would be set
        agRegistries.UnHideColumn(orIEN);
        agRegistries.UnHideColumn(orName);
        for i:=AvailableRegistries.Count-1 downto 0 do
          begin
            ri := AvailableRegistries[i];
            if (ri.IEN <> RegInfo.IEN) and (length(trim(ri.Description)) > 0) then
              with agRegistries do
                begin
                  AddRow;
                  rri := RowCount - 1;
                  GridCells[orName, rri]  := ri.Name;
                  GridCells[orDescr, rri] := ri.Description;
                  GridCells[orIEN, rri]   := ri.IEN;
                end;
          end;
      finally
        agRegistries.SortByColumn(1);
        //--- Moved from create method so that the proper IEN would be passed
        agRegistries.HideColumn(orIEN);
        agRegistries.HideColumn(orName);
        agRegistries.EndUpdate;
      end;

      //--- Populate the list of selection rules
      rawData := TStringList.Create;
      try
        cgvSelectionRules.Clear;
        if Broker.CallProc(rpcListSelectionRules,
          [RegInfo.IEN], nil, rawData) then
          begin
            rawData.Delete(0);
            cgvSelectionRules.Items.AssignRawData(rawData, [2,1,3]);
          end;
      finally
        rawData.Free;
      end;
      for i:=cgvSelectionRules.Items.Count-1 downto 0 do
        cgvSelectionRules.Items[i].Indent := 0;

      //--- Populate the list of registry Lab test groups ('3')
      fRegTests := TStringList.Create;
      if Broker.CallProc(rpcListItems, [RegInfo.IEN,'3'], nil, fRegTests) then
      begin
        fRegTests.Delete(0);
      end;

      //--- Populate the list of BMI test groups ('5')
      fBMITests := TStringList.Create;
      if Broker.CallProc(rpcListItems, [RegInfo.IEN,'5'], nil, fBMITests) then
      begin
        fBMITests.Delete(0);
      end;

      //--- Populate the list of Liver test groups ('6')
      fLiverTests := TStringList.Create;
      if Broker.CallProc(rpcListItems, [RegInfo.IEN,'6'], nil, fLiverTests) then
      begin
        fLiverTests.Delete(0);
      end;

      //--- Populate the list of Renal function test groups ('7')
      fRenalTests := TStringList.Create;
      if Broker.CallProc(rpcListItems, [RegInfo.IEN,'7'], nil, fRenalTests) then
      begin
        fRenalTests.Delete(0);
      end;

    end;

  if Assigned(RegInfo) then
  begin
    //--- Populate the list of local fields for the 'Local Fields' panel
    oldParams := TReportParameters.Create;
    rawData := TStringList.Create;
    try
      pnlParams100.GetFieldValues('', oldParams, rawData);
      rawData.Clear;
      agLocalFields.RemoveAll;
      if Broker.CallProc(rpcListLocalFields, [RegInfo.IEN], nil, rawData) then
      begin
        rawData.Delete(0);
        //--- Add pseudo local field for HIV registry
        if (RegInfo.IEN = '2') then
        begin
          rawData.Insert(0, '-999^Diagnosed at this VA^^Based upon answer to ' +
            'Patient Data Editor question - Was your VHA facility/station ' +
            'the first healthcare setting (VA or non-VA) to diagnose HIV');
        end;
        agLocalFields.AssignRawData(rawData, [-1,2,4,1]);
      end;
      pnlParams100.SetFieldValues('', oldParams);
    finally
      rawData.Free;
      oldParams.Free;
    end;
  end;
end;

//****** POPULATES VISIBLE CONTROLS WITH THE VALUES OF REPORT PARAMETERS

procedure TFrameReportParameters.SetFieldValues(const aReportCode: String;
  ReportParams: TReportParameters);
var
  i, n: Integer;
  pnlNode: TDomNode;
  sf: Boolean;
  qs: String;
begin
  //--- Find common nodes
  with ReportParams do
    begin
      fNodeDrugs    := FindNode('/PARAMS/DRUGS');
      fNodeColumns  := FindNode('/PARAMS/OPTIONAL_COLUMNS');
      fNodeOptions  := FindNode('/PARAMS/OPTIONS');
      fNodePatients := FindNode('/PARAMS/PATIENTS');
      pnlNode       := FindNode('/PARAMS/PANELS');
    end;

  //--- Populate controls of visible panels with the parameter values
  with scbxMain do
    begin
      n := ControlCount - 1;
      for i:=0 to n do
        if (Controls[i] is TCCRParamsPanel) and Controls[i].Visible then
          begin
            if Assigned(pnlNode) then
              begin
                qs := Format('PANEL[@ID="%d"]',[Controls[i].Tag]);
                sf := (pnlNode.FindNode(qs) <> nil);
              end
            else
              sf := True;
            if sf then
              TCCRParamsPanel(Controls[i]).SetFieldValues(aReportCode, ReportParams);
          end;
    end;
end;

//***** COMBINES THE PANELS REQUIRED FOR THE SELECTED REPORT

procedure TFrameReportParameters.SetupPanels(aReport: TReportDescriptor);
var
  i, n: Integer;
begin
  //--- Hide the scroll-box to reduce flicker
  scbxMain.Visible := False;
  try
    fCurrentReport := '';
    if Assigned(aReport) then
      with aReport.Panels do
        begin
          fCurrentReport := aReport.Code;
          //--- Show the parameter panels associated with the report
          n := Count - 1;
          for i:=0 to n do
            with TCCRParamsPanel(Objects[i]) do
              begin
                Visible  := True;
                Enabled  := True;
                Align    := alTop;
                TabOrder := i + 1;
              end;
          for i:=0 to n do
            TCCRParamsPanel(Objects[i]).Setup(aReport.Code);
          //--- Populate the controls with the values of report parameters
          SetFieldValues(aReport.Code, aReport.Parameters);
        end
    else
      with scbxMain do
        //--- Hide all parameter panels if the report reference is not provided
        for i:=ControlCount-1 downto 0 do
          begin
            Controls[i].Align := alBottom;
            Controls[i].Visible := False;
          end;
  finally
    //--- Always restore visibility of the scroll-box
    scbxMain.Visible := True;
  end;
end;

//***** UPDATES THE REFERENCES OF PANELS ASSOCIATED WITH THE REPORTS

procedure TFrameReportParameters.UpdatePanelReferences;
var
  i, iRep, iTag, lastCtrl: Integer;
  pnlTag: Longint;
  tmp: String;
  ctrl: TControl;
begin
  lastCtrl := scbxMain.ControlCount - 1;
  //--- Browse the available report descriptors
  for iRep:= RegInfo.AvailableReports.Count-1 downto 0 do
    with RegInfo.AvailableReports[iRep] do
      begin
        //--- Clear the list of old panel references
        Panels.Clear;
        //--- Build the new list
        iTag := 0;
        while True do
          begin
            Inc(iTag);
            //--- Get the panel tag from the report definition
            tmp := Piece(PanelTags, ',', iTag);
            if tmp = '' then Break;
            pnlTag := StrToIntDef(tmp, 0);
            if pnlTag <= 0 then Break;
            //--- Find the corresponding panel and add the reference to the list
            for i:=0 to lastCtrl do
              begin
                ctrl := scbxMain.Controls[i];
                if (ctrl is TCCRParamsPanel) and (ctrl.Tag = pnlTag) then
                  Panels.AddObject(IntToStr(pnlTag), ctrl);
              end;
          end;
      end;
end;

//***** VALIDATES THE (RE)SCHEDULING CODE

function TFrameReportParameters.validateScheduleCode(const aCode: String;
  const aDateTime: TDateTime): Boolean;
var
  rawData: TStringList;
begin
  Result := True;
  rawData := TStringList.Create;
  try
    if Broker.CallProc('ROR TASK VALIDATE RESCHEDULING',
      [aCode, FloatToStr(WindowsDateTimeToFMDateTime(aDateTime))],
      nil, rawData, [rpcSilent]) then
        Result := (StrToIntDef(Piece(rawData[0],U), 0) > 0);
  finally
    rawData.Free;
  end;
end;

procedure TFrameReportParameters.vxsComponentStateRestoreState(Sender: TObject);
var
  storage: TOvcAbstractStore;
begin
  storage := TOvcComponentState(Sender).Storage;
  if Assigned(storage) then
    begin
      ccrDivisionSelector.LoadLayout(storage, ssDivisionSelector);
      agLabRanges.LoadLayout(storage, ssLabRanges);
      ccrClinicSelector.LoadLayout(storage, ssClinicSelector);
      ccrLabTestSelector.LoadLayout(storage, ssLabTestSelector);
      ccrLTRSelector.LoadLayout(storage, ssLTRSelector);
      ccrICD9Selector.LoadLayout(storage, ssICD9Selector);
      ccrCPTSelector.LoadLayout(storage, ssCPTSelector);
      agRegistries.LoadLayout(storage, ssRegistries);
      agLocalFields.LoadLayout(storage, ssLocalFields);
      ccrDrugSelector.LoadLayout(storage, ssDrugSelector);
      ccrPatientSelector.LoadLayout(storage, ssPatientSelector);
    end;
end;

procedure TFrameReportParameters.vxsComponentStateSaveState(Sender: TObject);
var
  storage: TOvcAbstractStore;
begin
  storage := TOvcComponentState(Sender).Storage;
  if Assigned(storage) then
    begin
      ccrDivisionSelector.SaveLayout(storage, ssDivisionSelector);
      agLabRanges.SaveLayout(storage, ssLabRanges);
      ccrClinicSelector.SaveLayout(storage, ssClinicSelector);
      ccrLabTestSelector.SaveLayout(storage, ssLabTestSelector);
      ccrLTRSelector.SaveLayout(storage, ssLTRSelector);
      ccrICD9Selector.SaveLayout(storage, ssICD9Selector);
      ccrCPTSelector.SaveLayout(storage, ssCPTSelector);
      agRegistries.SaveLayout(storage, ssRegistries);
      agLocalFields.SaveLayout(storage, ssLocalFields);
      ccrDrugSelector.SaveLayout(storage, ssDrugSelector);
      ccrPatientSelector.SaveLayout(storage, ssPatientSelector);
    end;
end;

//***** Shared routine to enable/disable checkbox when user types in column

procedure TFrameReportParameters.agRangesSetEditText(Sender: TObject;
  ACol, ARow: Integer; const Value: String);
var
  cbs: Boolean;
  rri: integer;
begin
  with Sender as TCCRAdvColGrid do
    if ARow >= FixedRows then
    begin
      if ACol <> lrgToggle then
      begin
        GetCheckBoxState(lrgToggle, ARow, cbs);
        if not cbs then
        begin
          SetCheckBoxState(lrgToggle, ARow, True);
          RepaintCell(DisplColIndex(lrgToggle), DisplRowIndex(ARow));
          //-- For the Liver score report, we must enable/disable ULN field
          if fCurrentReport = '19' then
          begin
            rri := RealRowIndex(ARow);
            if (pos('MELD', AllCells[lrgGroupName,rri]) > 0) then
            begin
              edtUpperLimitAST047.Color := CtrlColor(false);
              edtUpperLimitAST047.Enabled := false;
              edtUpperLimitAST047.TabStop := false;
            end
            else if (pos('APRI', AllCells[lrgGroupName,rri]) > 0) then
            begin
              edtUpperLimitAST047.Color := CtrlColor(true);
              edtUpperLimitAST047.Enabled := true;
              edtUpperLimitAST047.TabStop := true;
            end;
          end;
        end;
      end;
    end;
end;

{$REGION ' Panel 010 - Date Range '}
///////////////////////////// Parameters Panel #010 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams010ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  TReportParameters(aList).DeleteNode('/PARAMS/DATE_RANGE');
end;

procedure TFrameReportParameters.pnlParams010GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
var
  dtFrom, dtTo: Double;
  dtQuarter, dtYear: Integer;
  params: TReportParameters;
  node: TDomNode;
begin
  params := TReportParameters(aList);
  node := params.GetNode('/PARAMS/DATE_RANGE');

  if cmbxDateType010.ItemIndex = 2 then
  begin
    dtFrom := WindowsDateToFMDate(Trunc(dtpFrom010.Date));
    dtTo   := WindowsDateToFMDate(Trunc(dtpTo010.Date));
    if dtFrom > dtTo then
    begin
      aMsgLst.Add(RSC00201);
      aField := dtpFrom010;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     FloatToStr(dtTo));
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   FloatToStr(dtFrom));
      SetAttrVal(node, dtrsType,    dtrsCustom);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType010.ItemIndex = 3 then
  begin
    if edCutOff010.Text = '' then
    begin
      aMsgLst.Add(RSC00202);
      aField := edCutOff010;
    end
    else if not isCutOffValid(edCutOff010.Text) then
    begin
      aMsgLst.Add(RSC00210);
      aField := edCutOff010;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  edCutOff010.Text);
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsCutOff);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType010.ItemIndex = 1 then
  begin
    dtYear := StrToIntDef(edYear010.Text, 0);
    dtQuarter := cmbxQuarter010.ItemIndex + 1;
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear010;
    end;
    if (dtQuarter < 1) or (dtQuarter > 4) then
    begin
      aMsgLst.Add(RSC00204);
      if not Assigned(aField) then
        aField := cmbxQuarter010;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal010.Checked);
      SetAttrVal(node, dtrsQuarter, IntToStr(dtQuarter));
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsQuarter);
      if dtYear > 0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end
  else if cmbxDateType010.ItemIndex = 0 then
  begin
    dtYear := StrToIntDef(edYear010.Text, 0);
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear010;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal010.Checked);
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsYear);
      if dtYear >0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams010Setup(const aReportCode: String);
begin
  if aReportCode = '12' then
  begin
    pnlParams010.Caption := 'Medications Date Range';
    cmbxDateType010.Hint := 'Medications date range type';
    edYear010.Hint       := 'Year of the medications';
    cmbxQuarter010.Hint  := 'Quarter of the medications';
    dtpFrom010.Hint      := 'Start date for the medications';
    spbMin010.Hint       := 'Do not use the start date for medications search';
    dtpTo010.Hint        := 'End date for the medications';
    spbMax010.Hint       := 'Do not use the end date for medications search';
  end
  else begin
    pnlParams010.Caption := 'Date Range';
    cmbxDateType010.Hint := 'Date range type';
    edYear010.Hint       := 'Year of the date range';
    cmbxQuarter010.Hint  := 'Quarter';
    dtpFrom010.Hint      := 'Start date for the range';
    spbMin010.Hint       := 'Do not use the start date for search';
    dtpTo010.Hint        := 'End date for the range';
    spbMax010.Hint       := 'Do not use the end date for search';
  end;

  edCutOff010.Left  := lblYear010.Left;
  dtpFrom010.Left   := lblYear010.Left;
  spbMin010.Left    := dtpFrom010.Left + dtpFrom010.Width + 3;
  dtpTo010.Left     := spbMin010.Left + 36;
  spbMax010.Left    := dtpTo010.Left + dtpTo010.Width + 3;

  stxtQuarter010.Top := lblQuarter010.Top;

  //--- Display Date Range Help button if registry is not HEPC or HIV
  btnDateRangeHelp010.Visible := (RegInfo.IEN <> '1') and (RegInfo.IEN <> '2');
  btnDateRangeHelp010.Enabled := btnDateRangeHelp010.Visible;
  if btnDateRangeHelp010.Visible then
    btnDateRangeHelp010.Top := edYear010.Top - 2;

  cmbxDateType010.ItemIndex := 0;
  cmbxDateType010Change(self);
end;

procedure TFrameReportParameters.pnlParams010SetValues(const aReportCode: String; aList: TCustomReportParameters);
var
  dtrType: String;
  dt, i: Integer;
  node: TDomNode;
  params: TReportParameters;
begin
  cbFiscal010.Checked := False;
  params := TReportParameters(aList);

  node := params.FindNode('/PARAMS/DATE_RANGE');
  if Assigned(node) then
    dtrType := params.GetAttrStr(node, dtrsType)
  else
    dtrType := '';

  if dtrType = dtrsCustom then
  begin
    cmbxDateType010.ItemIndex := 2;
    // Custom 'From' date
    try
      dt := params.GetAttrInt(node, dtrsStart);
      dtpFrom010.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpFrom010.Date := Date;
    end;
    // Custom 'To' date
    try
      dt := params.GetAttrInt(node, dtrsEnd);
      dtpTo010.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpTo010.Date := Date;
    end;
  end
  else if dtrType = dtrsCutOff then
  begin
    cmbxDateType010.ItemIndex := 3;
    edCutOff010.Text := params.GetAttrStr(node, dtrsCutOff);
  end
  else if dtrType = dtrsQuarter then
  begin
    cmbxDateType010.ItemIndex := 1;
    i := params.GetAttrInt(node, dtrsQuarter);
    if (i >= 1) and (i <= 4) then
      cmbxQuarter010.ItemIndex := i - 1
    else
      cmbxQuarter010.ItemIndex := -1;
    edYear010.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal010.Checked := True;
  end
  else if dtrType = dtrsYear then
  begin
    cmbxDateType010.ItemIndex := 0;
    edYear010.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal010.Checked := True;
  end
  else begin
    cmbxDateType010.ItemIndex := 0;
    edYear010.Text := '';
  end;
  cmbxDateType010Change(self);
end;

procedure TFrameReportParameters.cmbxDateType010Change(Sender: TObject);
begin
  lblYear010.Visible    := (cmbxDateType010.ItemIndex = 1) or CCRScreenReaderActive;
  lblYear010.Caption    := cmbxDateType010.Items[cmbxDateType010.ItemIndex];
  if cmbxDateType010.ItemIndex = 1 then
    lblYear010.Caption := cmbxDateType010.Items[0];
  lblQuarter010.Visible  := (cmbxDateType010.ItemIndex = 1) and CCRScreenReaderActive;
  stxtQuarter010.Visible := (cmbxDateType010.ItemIndex = 1);

  if lblYear010.Visible then
    edYear010.Left := lblYear010.Left + lblYear010.Width + 8
  else
    edYear010.Left := lblYear010.Left;
  cbFiscal010.Left := edYear010.Left + edYear010.Width + 8;
  cmbxQuarter010.Left := cbFiscal010.Left + cbFiscal010.Width + 10;
  if lblQuarter010.Visible then
    cmbxQuarter010.Left := lblQuarter010.Left + lblQuarter010.Width + 8;
  if lblYear010.Visible then
    stxtQuarter010.Left := cmbxQuarter010.Left + cmbxQuarter010.Width + 20;
  stxtQuarter010.TabStop := lblQuarter010.Visible;

  edYear010.Visible      := (cmbxDateType010.ItemIndex = 0) or (cmbxDateType010.ItemIndex = 1);
  cmbxQuarter010.Visible := (cmbxDateType010.ItemIndex = 1);
  dtpFrom010.Visible     := (cmbxDateType010.ItemIndex = 2);
  edCutOff010.Visible    := (cmbxDateType010.ItemIndex = 3);

  edYear010.Enabled      := edYear010.Visible;
  cbFiscal010.Visible    := edYear010.Visible;
  cbFiscal010.Enabled    := edYear010.Visible;
  cmbxQuarter010.Enabled := cmbxQuarter010.Visible;

  dtpTo010.Visible    := dtpFrom010.Visible;
  spbMax010.Visible   := dtpFrom010.Visible;
  spbMin010.Visible   := dtpFrom010.Visible;
  dtpFrom010.Enabled  := dtpFrom010.Visible;
  dtpTo010.Enabled    := dtpFrom010.Visible;
  spbMax010.Enabled   := dtpFrom010.Visible;
  spbMin010.Enabled   := dtpFrom010.Visible;

  edCutOff010.Enabled := edCutOff010.Visible;
  if btnDateRangeHelp010.Visible then
    btnDateRangeHelp010.Left := stxtQuarter010.Left + stxtQuarter010.Width + 25;
end;

procedure TFrameReportParameters.spbMax010Click(Sender: TObject);
begin
  dtpTo010.Date := Date;
end;

procedure TFrameReportParameters.spbMin010Click(Sender: TObject);
begin
  dtpFrom010.Date := dtpFrom010.MinDate;
end;
{$ENDREGION}

{$REGION ' Panel 011 - Date Range 2 '}
///////////////////////////// Parameters Panel #011 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams011ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  TReportParameters(aList).DeleteNode('/PARAMS/DATE_RANGE_2');
end;

procedure TFrameReportParameters.pnlParams011GetValues(
  const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
var
  dtFrom, dtTo: Double;
  dtQuarter, dtYear: Integer;
  params: TReportParameters;
  node: TDomNode;
begin
  params := TReportParameters(aList);
  node := params.GetNode('/PARAMS/DATE_RANGE_2');

  if cmbxDateType011.ItemIndex = 2 then
  begin
    dtFrom := WindowsDateToFMDate(Trunc(dtpFrom011.Date));
    dtTo   := WindowsDateToFMDate(Trunc(dtpTo011.Date));
    if dtFrom > dtTo then
    begin
      aMsgLst.Add(RSC00201);
      aField := dtpFrom011;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     FloatToStr(dtTo));
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   FloatToStr(dtFrom));
      SetAttrVal(node, dtrsType,    dtrsCustom);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType011.ItemIndex = 3 then
  begin
    if edCutOff011.Text = '' then
    begin
      aMsgLst.Add(RSC00202);
      aField := edCutOff011;
    end
    else if not isCutOffValid(edCutOff011.Text) then
    begin
      aMsgLst.Add(RSC00210);
      aField := edCutOff011;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  edCutOff011.Text);
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsCutOff);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType011.ItemIndex = 1 then
  begin
    dtYear := StrToIntDef(edYear011.Text, 0);
    dtQuarter := cmbxQuarter011.ItemIndex + 1;
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear011;
    end;
    if (dtQuarter < 1) or (dtQuarter > 4) then
    begin
      aMsgLst.Add(RSC00204);
      if not Assigned(aField) then
        aField := cmbxQuarter011;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal011.Checked);
      SetAttrVal(node, dtrsQuarter, IntToStr(dtQuarter));
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsQuarter);
      if dtYear > 0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end
  else if cmbxDateType011.ItemIndex = 0 then
  begin
    dtYear := StrToIntDef(edYear011.Text, 0);
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear011;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal011.Checked);
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsYear);
      if dtYear >0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams011Setup(const aReportCode: string);
begin
  edCutOff011.Left  := lblYear011.Left;
  dtpFrom011.Left   := lblYear011.Left;
  spbMin011.Left    := dtpFrom011.Left + dtpFrom011.Width + 3;
  dtpTo011.Left     := spbMin011.Left + 36;
  spbMax011.Left    := dtpTo011.Left + dtpTo011.Width + 3;

  stxtQuarter011.Top := lblQuarter011.Top;

  //--- Display Date Range Help button if registry is not HEPC or HIV
  btnDateRangeHelp011.Visible := (RegInfo.IEN <> '1') and (RegInfo.IEN <> '2');
  btnDateRangeHelp011.Enabled := btnDateRangeHelp011.Visible;
  if btnDateRangeHelp011.Visible then
    btnDateRangeHelp011.Top := edYear011.Top - 2;

  cmbxDateType011.ItemIndex := 0;
  cmbxDateType011Change(self);
end;

procedure TFrameReportParameters.pnlParams011SetValues(
  const aReportCode: String; aList: TCustomReportParameters);
var
  dtrType: String;
  dt, i: Integer;
  node: TDomNode;
  params: TReportParameters;
begin
  cbFiscal011.Checked := False;
  params := TReportParameters(aList);

  node := params.FindNode('/PARAMS/DATE_RANGE_2');
  if Assigned(node) then
    dtrType := params.GetAttrStr(node, dtrsType)
  else
    dtrType := '';

  if dtrType = dtrsCustom then
  begin
    cmbxDateType011.ItemIndex := 2;
    // Custom 'From' date
    try
      dt := params.GetAttrInt(node, dtrsStart);
      dtpFrom011.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpFrom011.Date := Date;
    end;
    // Custom 'To' date
    try
      dt := params.GetAttrInt(node, dtrsEnd);
      dtpTo011.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpTo011.Date := Date;
    end;
  end
  else if dtrType = dtrsCutOff then
  begin
    cmbxDateType011.ItemIndex := 3;
    edCutOff011.Text := params.GetAttrStr(node, dtrsCutOff);
  end
  else if dtrType = dtrsQuarter then
  begin
    cmbxDateType011.ItemIndex := 1;
    i := params.GetAttrInt(node, dtrsQuarter);
    if (i >= 1) and (i <= 4) then
      cmbxQuarter011.ItemIndex := i - 1
    else
      cmbxQuarter011.ItemIndex := -1;
    edYear011.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal011.Checked := True;
  end
  else if dtrType = dtrsYear then
  begin
    cmbxDateType011.ItemIndex := 0;
    edYear011.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal011.Checked := True;
  end
  else begin
    cmbxDateType011.ItemIndex := 0;
    edYear011.Text := '';
  end;
  cmbxDateType011Change(self);
end;

procedure TFrameReportParameters.cmbxDateType011Change(Sender: TObject);
begin
  lblYear011.Visible    := (cmbxDateType011.ItemIndex = 1) or CCRScreenReaderActive;
  lblYear011.Caption    := cmbxDateType011.Items[cmbxDateType011.ItemIndex];
  if cmbxDateType011.ItemIndex = 1 then
    lblYear011.Caption := cmbxDateType011.Items[0];
  lblQuarter011.Visible  := (cmbxDateType011.ItemIndex = 1) and CCRScreenReaderActive;
  stxtQuarter011.Visible := (cmbxDateType011.ItemIndex = 1);

  if lblYear011.Visible then
    edYear011.Left := lblYear011.Left + lblYear011.Width + 8
  else
    edYear011.Left := lblYear011.Left;
  cbFiscal011.Left := edYear011.Left + edYear011.Width + 8;
  cmbxQuarter011.Left := cbFiscal011.Left + cbFiscal011.Width + 10;
  if lblQuarter011.Visible then
    cmbxQuarter011.Left := lblQuarter011.Left + lblQuarter011.Width + 8;
  if lblYear011.Visible then
    stxtQuarter011.Left := cmbxQuarter011.Left + cmbxQuarter011.Width + 20;
  stxtQuarter011.TabStop := lblQuarter011.Visible;

  edYear011.Visible      := (cmbxDateType011.ItemIndex = 0) or (cmbxDateType011.ItemIndex = 1);
  cmbxQuarter011.Visible := (cmbxDateType011.ItemIndex = 1);
  dtpFrom011.Visible     := (cmbxDateType011.ItemIndex = 2);
  edCutOff011.Visible    := (cmbxDateType011.ItemIndex = 3);

  edYear011.Enabled      := edYear011.Visible;
  cbFiscal011.Visible    := edYear011.Visible;
  cbFiscal011.Enabled    := edYear011.Visible;
  cmbxQuarter011.Enabled := cmbxQuarter011.Visible;

  dtpTo011.Visible    := dtpFrom011.Visible;
  spbMax011.Visible   := dtpFrom011.Visible;
  spbMin011.Visible   := dtpFrom011.Visible;
  dtpFrom011.Enabled  := dtpFrom011.Visible;
  dtpTo011.Enabled    := dtpFrom011.Visible;
  spbMax011.Enabled   := dtpFrom011.Visible;
  spbMin011.Enabled   := dtpFrom011.Visible;

  edCutOff011.Enabled := edCutOff011.Visible;
  if btnDateRangeHelp011.Visible then
    btnDateRangeHelp011.Left := stxtQuarter011.Left + stxtQuarter011.Width + 25;
end;

procedure TFrameReportParameters.spbMax011Click(Sender: TObject);
begin
  dtpTo011.Date := Date;
end;

procedure TFrameReportParameters.spbMin011Click(Sender: TObject);
begin
  dtpFrom011.Date := dtpFrom011.MinDate;
end;
{$ENDREGION}

{$REGION ' Panel 012 - Date Range 3 '}
///////////////////////////// Parameters Panel #012 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams012ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  TReportParameters(aList).DeleteNode('/PARAMS/DATE_RANGE_3');
end;

procedure TFrameReportParameters.pnlParams012GetValues(
  const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
var
  dtFrom, dtTo: Double;
  dtQuarter, dtYear: Integer;
  params: TReportParameters;
  node: TDomNode;
begin
  params := TReportParameters(aList);
  node := params.GetNode('/PARAMS/DATE_RANGE_3');

  if cmbxDateType012.ItemIndex = 2 then
  begin
    dtFrom := WindowsDateToFMDate(Trunc(dtpFrom012.Date));
    dtTo   := WindowsDateToFMDate(Trunc(dtpTo012.Date));
    if dtFrom > dtTo then
    begin
      aMsgLst.Add(RSC00201);
      aField := dtpFrom012;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     FloatToStr(dtTo));
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   FloatToStr(dtFrom));
      SetAttrVal(node, dtrsType,    dtrsCustom);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType012.ItemIndex = 3 then
  begin
    if edCutOff012.Text = '' then
    begin
      aMsgLst.Add(RSC00202);
      aField := edCutOff012;
    end
    else if not isCutOffValid(edCutOff012.Text) then
    begin
      aMsgLst.Add(RSC00210);
      aField := edCutOff012;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  edCutOff012.Text);
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsCutOff);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType012.ItemIndex = 1 then
  begin
    dtYear := StrToIntDef(edYear012.Text, 0);
    dtQuarter := cmbxQuarter012.ItemIndex + 1;
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear012;
    end;
    if (dtQuarter < 1) or (dtQuarter > 4) then
    begin
      aMsgLst.Add(RSC00204);
      if not Assigned(aField) then
        aField := cmbxQuarter012;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal012.Checked);
      SetAttrVal(node, dtrsQuarter, IntToStr(dtQuarter));
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsQuarter);
      if dtYear > 0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end
  else if cmbxDateType012.ItemIndex = 0 then
  begin
    dtYear := StrToIntDef(edYear012.Text, 0);
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear012;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal012.Checked);
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsYear);
      if dtYear >0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams012Setup(const aReportCode: string);
begin
  edCutOff012.Left   := lblYear012.Left;
  dtpFrom012.Left    := lblYear012.Left;
  spbMin012.Left     := dtpFrom012.Left + dtpFrom012.Width + 3;
  dtpTo012.Left      := spbMin012.Left + 36;
  spbMax012.Left     := dtpTo012.Left + dtpTo012.Width + 3;
  stxtQuarter012.Top := lblQuarter012.Top;

  //--- Display Date Range Help button if registry is not HEPC or HIV
  btnDateRangeHelp012.Visible := (RegInfo.IEN <> '1') and (RegInfo.IEN <> '2');
  btnDateRangeHelp012.Enabled := btnDateRangeHelp012.Visible;
  if btnDateRangeHelp012.Visible then
    btnDateRangeHelp012.Top := edYear012.Top - 2;

  cmbxDateType012.ItemIndex := 0;
  cmbxDateType012Change(self);
end;

procedure TFrameReportParameters.pnlParams012SetValues(
  const aReportCode: String; aList: TCustomReportParameters);
var
  dtrType: String;
  dt, i: Integer;
  node: TDomNode;
  params: TReportParameters;
begin
  cbFiscal012.Checked := False;
  params := TReportParameters(aList);

  node := params.FindNode('/PARAMS/DATE_RANGE_3');
  if Assigned(node) then
    dtrType := params.GetAttrStr(node, dtrsType)
  else
    dtrType := '';

  if dtrType = dtrsCustom then
  begin
    cmbxDateType012.ItemIndex := 2;
    // Custom 'From' date
    try
      dt := params.GetAttrInt(node, dtrsStart);
      dtpFrom012.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpFrom012.Date := Date;
    end;
    // Custom 'To' date
    try
      dt := params.GetAttrInt(node, dtrsEnd);
      dtpTo012.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpTo012.Date := Date;
    end;
  end
  else if dtrType = dtrsCutOff then
  begin
    cmbxDateType012.ItemIndex := 3;
    edCutOff012.Text := params.GetAttrStr(node, dtrsCutOff);
  end
  else if dtrType = dtrsQuarter then
  begin
    cmbxDateType012.ItemIndex := 1;
    i := params.GetAttrInt(node, dtrsQuarter);
    if (i >= 1) and (i <= 4) then
      cmbxQuarter012.ItemIndex := i - 1
    else
      cmbxQuarter012.ItemIndex := -1;
    edYear012.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal012.Checked := True;
  end
  else if dtrType = dtrsYear then
  begin
    cmbxDateType012.ItemIndex := 0;
    edYear012.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal012.Checked := True;
  end
  else begin
    cmbxDateType012.ItemIndex := 0;
    edYear012.Text := '';
  end;
  cmbxDateType012Change(self);
end;

procedure TFrameReportParameters.cmbxDateType012Change(Sender: TObject);
begin
  lblYear012.Visible    := (cmbxDateType012.ItemIndex = 1) or CCRScreenReaderActive;
  lblYear012.Caption    := cmbxDateType012.Items[cmbxDateType012.ItemIndex];
  if cmbxDateType012.ItemIndex = 1 then
    lblYear012.Caption := cmbxDateType012.Items[0];
  lblQuarter012.Visible  := (cmbxDateType012.ItemIndex = 1) and CCRScreenReaderActive;
  stxtQuarter012.Visible := (cmbxDateType012.ItemIndex = 1);

  if lblYear012.Visible then
    edYear012.Left := lblYear012.Left + lblYear012.Width + 8
  else
    edYear012.Left := lblYear012.Left;
  cbFiscal012.Left := edYear012.Left + edYear012.Width + 8;
  cmbxQuarter012.Left := cbFiscal012.Left + cbFiscal012.Width + 10;
  if lblQuarter012.Visible then
    cmbxQuarter012.Left := lblQuarter012.Left + lblQuarter012.Width + 8;
  if lblYear012.Visible then
    stxtQuarter012.Left := cmbxQuarter012.Left + cmbxQuarter012.Width + 20;
  stxtQuarter012.TabStop := lblQuarter012.Visible;

  edYear012.Visible      := (cmbxDateType012.ItemIndex = 0) or (cmbxDateType012.ItemIndex = 1);
  cmbxQuarter012.Visible := (cmbxDateType012.ItemIndex = 1);
  dtpFrom012.Visible     := (cmbxDateType012.ItemIndex = 2);
  edCutOff012.Visible    := (cmbxDateType012.ItemIndex = 3);

  edYear012.Enabled      := edYear012.Visible;
  cbFiscal012.Visible    := edYear012.Visible;
  cbFiscal012.Enabled    := edYear012.Visible;
  cmbxQuarter012.Enabled := cmbxQuarter012.Visible;

  dtpTo012.Visible    := dtpFrom012.Visible;
  spbMax012.Visible   := dtpFrom012.Visible;
  spbMin012.Visible   := dtpFrom012.Visible;
  dtpFrom012.Enabled  := dtpFrom012.Visible;
  dtpTo012.Enabled    := dtpFrom012.Visible;
  spbMax012.Enabled   := dtpFrom012.Visible;
  spbMin012.Enabled   := dtpFrom012.Visible;

  edCutOff012.Enabled := edCutOff012.Visible;
  if btnDateRangeHelp012.Visible then
    btnDateRangeHelp012.Left := stxtQuarter012.Left + stxtQuarter012.Width + 25;
end;

procedure TFrameReportParameters.spbMax012Click(Sender: TObject);
begin
  dtpTo012.Date := Date;
end;

procedure TFrameReportParameters.spbMin012Click(Sender: TObject);
begin
  dtpFrom012.Date := dtpFrom012.MinDate;
end;
{$ENDREGION}

{$REGION ' Panel 013 - Date Range 4 '}
///////////////////////////// Parameters Panel #013 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams013ClearParams(
  const aReportCode: string; aList: TCustomReportParameters);
begin
  TReportParameters(aList).DeleteNode('/PARAMS/DATE_RANGE_4');
end;

procedure TFrameReportParameters.pnlParams013GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
var
  dtFrom, dtTo: Double;
  dtQuarter, dtYear: Integer;
  params: TReportParameters;
  node: TDomNode;
begin
  params := TReportParameters(aList);
  node := params.GetNode('/PARAMS/DATE_RANGE_4');

  if cmbxDateType013.ItemIndex = 2 then
  begin
    dtFrom := WindowsDateToFMDate(Trunc(dtpFrom013.Date));
    dtTo   := WindowsDateToFMDate(Trunc(dtpTo013.Date));
    if dtFrom > dtTo then
    begin
      aMsgLst.Add(RSC00201);
      aField := dtpFrom013;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     FloatToStr(dtTo));
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   FloatToStr(dtFrom));
      SetAttrVal(node, dtrsType,    dtrsCustom);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType013.ItemIndex = 3 then
  begin
    if edCutOff013.Text = '' then
    begin
      aMsgLst.Add(RSC00202);
      aField := edCutOff013;
    end
    else if not isCutOffValid(edCutOff013.Text) then
    begin
      aMsgLst.Add(RSC00210);
      aField := edCutOff013;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  edCutOff013.Text);
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  '');
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsCutOff);
      SetAttrVal(node, dtrsYear,    '');
    end;
  end
  else if cmbxDateType013.ItemIndex = 1 then
  begin
    dtYear := StrToIntDef(edYear013.Text, 0);
    dtQuarter := cmbxQuarter013.ItemIndex + 1;
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear013;
    end;
    if (dtQuarter < 1) or (dtQuarter > 4) then
    begin
      aMsgLst.Add(RSC00204);
      if not Assigned(aField) then
        aField := cmbxQuarter013;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal013.Checked);
      SetAttrVal(node, dtrsQuarter, IntToStr(dtQuarter));
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsQuarter);
      if dtYear > 0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end
  else if cmbxDateType013.ItemIndex = 0 then
  begin
    dtYear := StrToIntDef(edYear013.Text, 0);
    if dtYear <= 0 then
    begin
      aMsgLst.Add(RSC00203);
      aField := edYear013;
    end;
    with params do
    begin
      SetAttrVal(node, dtrsCutOff,  '');
      SetAttrVal(node, dtrsEnd,     '');
      SetAttrVal(node, dtrsFiscal,  cbFiscal013.Checked);
      SetAttrVal(node, dtrsQuarter, '');
      SetAttrVal(node, dtrsStart,   '');
      SetAttrVal(node, dtrsType,    dtrsYear);
      if dtYear >0 then
        SetAttrVal(node, dtrsYear,  IntToStr(dtYear))
      else
        SetAttrVal(node, dtrsYear,  '');
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams013Setup(const aReportCode: string);
begin
  edCutOff013.Left   := lblYear013.Left;
  dtpFrom013.Left    := lblYear013.Left;
  spbMin013.Left     := dtpFrom013.Left + dtpFrom013.Width + 3;
  dtpTo013.Left      := spbMin013.Left + 36;
  spbMax013.Left     := dtpTo013.Left + dtpTo013.Width + 3;
  stxtQuarter013.Top := lblQuarter013.Top;

  cmbxDateType013.ItemIndex := 0;
  cmbxDateType013Change(self);
end;

procedure TFrameReportParameters.pnlParams013SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
var
  dtrType: String;
  dt, i: Integer;
  node: TDomNode;
  params: TReportParameters;
begin
  cbFiscal013.Checked := False;
  params := TReportParameters(aList);

  node := params.FindNode('/PARAMS/DATE_RANGE_4');
  if Assigned(node) then
    dtrType := params.GetAttrStr(node, dtrsType)
  else
    dtrType := '';

  if dtrType = dtrsCustom then
  begin
    cmbxDateType013.ItemIndex := 2;
    // Custom 'From' date
    try
      dt := params.GetAttrInt(node, dtrsStart);
      dtpFrom013.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpFrom013.Date := Date;
    end;
    // Custom 'To' date
    try
      dt := params.GetAttrInt(node, dtrsEnd);
      dtpTo013.Date := FMDateTimeToWindowsDateTime(dt);
    except
      dtpTo013.Date := Date;
    end;
  end
  else if dtrType = dtrsCutOff then
  begin
    cmbxDateType013.ItemIndex := 3;
    edCutOff013.Text := params.GetAttrStr(node, dtrsCutOff);
  end
  else if dtrType = dtrsQuarter then
  begin
    cmbxDateType013.ItemIndex := 1;
    i := params.GetAttrInt(node, dtrsQuarter);
    if (i >= 1) and (i <= 4) then
      cmbxQuarter013.ItemIndex := i - 1
    else
      cmbxQuarter013.ItemIndex := -1;
    edYear013.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal013.Checked := True;
  end
  else if dtrType = dtrsYear then
  begin
    cmbxDateType013.ItemIndex := 0;
    edYear013.Text := params.GetAttrStr(node, dtrsYear);
    if params.GetAttrBool(node, dtrsFiscal) then
      cbFiscal013.Checked := True;
  end
  else begin
    cmbxDateType013.ItemIndex := 0;
    edYear013.Text := '';
  end;
  cmbxDateType013Change(self);
end;

procedure TFrameReportParameters.cmbxDateType013Change(Sender: TObject);
begin
  lblYear013.Visible    := (cmbxDateType013.ItemIndex = 1) or CCRScreenReaderActive;
  lblYear013.Caption    := cmbxDateType013.Items[cmbxDateType013.ItemIndex];
  if cmbxDateType013.ItemIndex = 1 then
    lblYear013.Caption := cmbxDateType013.Items[0];
  lblQuarter013.Visible  := (cmbxDateType013.ItemIndex = 1) and CCRScreenReaderActive;
  stxtQuarter013.Visible := (cmbxDateType013.ItemIndex = 1);

  if lblYear013.Visible then
    edYear013.Left := lblYear013.Left + lblYear013.Width + 8
  else
    edYear013.Left := lblYear013.Left;
  cbFiscal013.Left := edYear013.Left + edYear013.Width + 8;
  cmbxQuarter013.Left := cbFiscal013.Left + cbFiscal013.Width + 10;
  if lblQuarter013.Visible then
    cmbxQuarter013.Left := lblQuarter013.Left + lblQuarter013.Width + 8;
  if lblYear013.Visible then
    stxtQuarter013.Left := cmbxQuarter013.Left + cmbxQuarter013.Width + 20;
  stxtQuarter013.TabStop := lblQuarter013.Visible;

  edYear013.Visible      := (cmbxDateType013.ItemIndex = 0) or (cmbxDateType013.ItemIndex = 1);
  cmbxQuarter013.Visible := (cmbxDateType013.ItemIndex = 1);
  dtpFrom013.Visible     := (cmbxDateType013.ItemIndex = 2);
  edCutOff013.Visible    := (cmbxDateType013.ItemIndex = 3);

  edYear013.Enabled      := edYear013.Visible;
  cbFiscal013.Visible    := edYear013.Visible;
  cbFiscal013.Enabled    := edYear013.Visible;
  cmbxQuarter013.Enabled := cmbxQuarter013.Visible;

  dtpTo013.Visible    := dtpFrom013.Visible;
  spbMax013.Visible   := dtpFrom013.Visible;
  spbMin013.Visible   := dtpFrom013.Visible;
  dtpFrom013.Enabled  := dtpFrom013.Visible;
  dtpTo013.Enabled    := dtpFrom013.Visible;
  spbMax013.Enabled   := dtpFrom013.Visible;
  spbMin013.Enabled   := dtpFrom013.Visible;

  edCutOff013.Enabled := edCutOff013.Visible;
end;

procedure TFrameReportParameters.spbMax013Click(Sender: TObject);
begin
  dtpTo013.Date := Date;
end;

procedure TFrameReportParameters.spbMin013Click(Sender: TObject);
begin
  dtpFrom013.Date := dtpFrom013.MinDate;
end;
{$ENDREGION}

{$REGION ' Panel 014 - Scheduled to Run On '}
///////////////////////////// Parameters Panel #014 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams014GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  TReportParameters(aList).SetNodeVal('/PARAMS/TASK_COMMENT', edTaskComment.Text);
  if not validateScheduleCode(cmbbSchedule.Text, getDTRun) then
    begin
      aMsgLst.Add(RSC00205);
      aField := cmbbSchedule;
    end;
end;

procedure TFrameReportParameters.pnlParams014SetValues(const aReportCode: String; aList: TCustomReportParameters);
var
  dtn: TDateTime;
begin
  cmbbSchedule.Text      := '';
  edTaskComment.Text     := TReportParameters(aList).GetNodeVal('/PARAMS/TASK_COMMENT');

  dtn := GetServerDateTime();
  dtpScheduleDay.Date    := DateOf(dtn);
  dtpScheduleDay.MinDate := dtpScheduleDay.Date;
  dtpScheduleTime.Time   := TimeOf(dtn);
end;
{$ENDREGION}

{$REGION ' Panel 020 - Registry Status '}
///////////////////////////// Parameters Panel #020 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams020GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
var
  dateConfirm: Double;
begin
  with TReportParameters(aList) do
  begin
    SetAttrVal(NodePatients, 'CONFIRMED', cbConfirmed.Checked);
    SetAttrVal(NodePatients, 'PENDING',   cbPending.Checked);
    SetAttrVal(NodePatients, 'CONFIRM_AFTER', cbConfirmAfter.Checked);
    if cbConfirmAfter.Checked then
    begin
      dateConfirm := WindowsDateToFMDate(Trunc(dtpConfirmAfter.Date));
      SetAttrVal(NodePatients, 'CONFDT_AFTER', FloatToStr(dateConfirm));
    end
    else
      SetAttrVal(NodePatients, 'CONFDT_AFTER', '');
  end;
  if not (cbConfirmed.Checked or cbPending.Checked or cbConfirmAfter.Checked) then
  begin
    aMsgLst.Add(RSC00206);
    aField := cbConfirmed;
  end;
end;

procedure TFrameReportParameters.pnlParams020Setup(const aReportCode: string);
begin
  cbPending.Checked := false;
  cbPending.Visible := (not RegInfo.AutoConfirm);
  cbPending.Enabled := cbPending.Visible;
end;

procedure TFrameReportParameters.pnlParams020SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  dateConfirm: Double;
begin
  with TReportParameters(aList) do
  begin
    cbConfirmed.Checked    := GetAttrBool(NodePatients, 'CONFIRMED');
    cbPending.Checked      := GetAttrBool(NodePatients, 'PENDING');
    cbConfirmAfter.Checked := GetAttrBool(NodePatients, 'CONFIRM_AFTER');
    if cbConfirmAfter.Checked then
    begin
      try
        dateConfirm := GetAttrInt(NodePatients, 'CONFDT_AFTER');
        if dateConfirm = 0 then
          dtpConfirmAfter.Date := Date
        else
          dtpConfirmAfter.Date := FMDateTimeToWindowsDateTime(dateConfirm);
      except
        dtpConfirmAfter.Date := Date;
      end;
    end;
  end;
end;

procedure TFrameReportParameters.cbConfirmedClick(Sender: TObject);
begin
  if cbConfirmed.Checked then
    cbConfirmAfter.Checked := false;
end;

procedure TFrameReportParameters.cbPendingClick(Sender: TObject);
begin
  cbPendingComments.Enabled := cbPending.Checked;
  if not cbPending.Checked then
    cbPendingComments.Checked := false;
end;

procedure TFrameReportParameters.cbConfirmAfterClick(Sender: TObject);
begin
  if cbConfirmAfter.Checked then
  begin
    cbConfirmed.Checked := false;
    cbPending.Checked := false;
  end;
  if cbPending.Visible then
    cbPending.Enabled := not cbConfirmAfter.Checked;
  dtpConfirmAfter.Enabled := cbConfirmAfter.Checked;
end;
{$ENDREGION}

{$REGION ' Panel 022 - Include Patients Confirmed '}
///////////////////////////// Parameters Panel #022 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams022GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodePatients, 'DE_AFTER',  cbAfter.Checked);
      SetAttrVal(NodePatients, 'DE_BEFORE', cbBefore.Checked);
      SetAttrVal(NodePatients, 'DE_DURING', cbDuring.Checked);
    end;
  if not (cbBefore.Checked or cbDuring.Checked or cbAfter.Checked) then
    begin
      aMsgLst.Add(RSC00206);
      aField := cbBefore;
    end;
end;

procedure TFrameReportParameters.pnlParams022SetValues(const aReportCode: String; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      cbAfter.Checked  := GetAttrBool(NodePatients, 'DE_AFTER');
      cbBefore.Checked := GetAttrBool(NodePatients, 'DE_BEFORE');
      cbDuring.Checked := GetAttrBool(NodePatients, 'DE_DURING');
    end;
end;
{$ENDREGION}

{$REGION ' Panel 023 - Sex '}
procedure TFrameReportParameters.pnlParams023GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
begin
  with NodePatients do
    removeAttribute('SEX');

  with TReportParameters(aList) do
    if rbSexMale.Checked then
      SetAttrVal(NodePatients, 'SEX', 'M')
    else if rbSexFemale.Checked then
      SetAttrVal(NodePatients, 'SEX', 'F');
end;

procedure TFrameReportParameters.pnlParams023SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
var tmpValue: string;
begin
  with TReportParameters(aList) do
  begin
    fNodePatients := GetNode('/PARAMS/PATIENTS');
    if Assigned(NodePatients) then
    begin
      tmpValue := GetAttrStr(NodePatients, 'SEX');
      if tmpValue = 'M' then
        rbSexMale.Checked := true
      else if tmpValue = 'F' then
        rbSexFemale.Checked := true
      else
        rbSexBoth.Checked := true;
    end
    else
      rbSexBoth.Checked := true;
  end;
end;
{$ENDREGION}

{$REGION ' Panel 024 - Additional Identifier '}
procedure TFrameReportParameters.pnlParams024GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
begin
  with NodePatients do
    removeAttribute('ICN');

  if cbICN.Checked then
    TReportParameters(aList).SetAttrVal(NodePatients, 'ICN', '1');
end;

procedure TFrameReportParameters.pnlParams024SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
  begin
    fNodePatients := GetNode('/PARAMS/PATIENTS');
    if Assigned(NodePatients) then
      cbICN.Checked := GetAttrBool(NodePatients, 'ICN')
    else
      cbICN.Checked := false;
  end;
end;

{$ENDREGION}

{$REGION ' Panel 025 - OEF/OIF '}
procedure TFrameReportParameters.pnlParams025GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
begin
  with NodePatients do
    removeAttribute('OEF');

  with TReportParameters(aList) do
    if rbOEFInclude.Checked then
      SetAttrVal(NodePatients, 'OEF', '1')
    else if rbOEFExclude.Checked then
      SetAttrVal(NodePatients, 'OEF', '-1');
end;

procedure TFrameReportParameters.pnlParams025SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
var tmpValue: string;
begin
  with TReportParameters(aList) do
  begin
    fNodePatients := GetNode('/PARAMS/PATIENTS');
    if Assigned(NodePatients) then
    begin
      tmpValue := GetAttrStr(NodePatients, 'OEF');
      if tmpValue = '1' then
        rbOEFInclude.Checked := true
      else if tmpValue = '-1' then
        rbOEFExclude.Checked := true
      else
        rbOEFAll.Checked := true;
    end
    else
      rbOEFAll.Checked := true;
  end;
end;
{$ENDREGION}

{$REGION ' Panel 026 - Activity '}
///////////////////////////// Parameters Panel #026 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams026GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodePatients, 'INPATIENT',  cbInpatient.Checked);
      SetAttrVal(NodePatients, 'OUTPATIENT', cbOutpatient.Checked);
    end;
  if not (cbInpatient.Checked or cbOutpatient.Checked) then
    begin
      aMsgLst.Add(RSC00206);
      aField := cbInpatient;
    end;
end;

procedure TFrameReportParameters.pnlParams026SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      cbInpatient.Checked  := GetAttrBool(NodePatients, 'INPATIENT');
      cbOutpatient.Checked := GetAttrBool(NodePatients, 'OUTPATIENT');
    end;
end;
{$ENDREGION}

{$REGION ' Panel 028 - Options '}
///////////////////////////// Parameters Panel #028 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams028GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodeOptions,  'REGMEDSMRY', cbRegMedSMRY.Checked);
      SetAttrVal(NodeOptions,  'PTLIST',     cbVERAPtList.Checked);
      SetAttrVal(NodePatients, 'BASIC',      cbVERABasic.Checked);
      SetAttrVal(NodePatients, 'COMPLEX',    cbVERAComplex.Checked);
    end;
  if not (cbVERABasic.Checked or cbVERAComplex.Checked) then
    begin
      aMsgLst.Add(RSC00207);
      aField := cbVERAComplex;
    end;
end;

procedure TFrameReportParameters.pnlParams028SetValues(const aReportCode: String; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      cbRegMedSMRY.Checked  := GetAttrBool(NodeOptions,  'REGMEDSMRY');
      cbVERAPtList.Checked  := GetAttrBool(NodeOptions,  'PTLIST');
      cbVERABasic.Checked   := GetAttrBool(NodePatients, 'BASIC');
      cbVERAComplex.Checked := GetAttrBool(NodePatients, 'COMPLEX');
    end;
end;
{$ENDREGION}

{$REGION ' Panel 030 - Report Options '}
///////////////////////////// Parameters Panel #030 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams030GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
begin
  setColumnOption('AGE',      cbAge.Checked);
  setColumnOption('CONFDT',   cbDateConf.Checked);
  setColumnOption('DOB',      cbDateOfBirth.Checked);
  setColumnOption('DOD',      cbDateOfDeath.Checked);
  setColumnOption('RACE',     cbRace.Checked);
  setColumnOption('SELDT',    cbDateSel.Checked);
  setColumnOption('SEX',      cbSex.Checked);
  setColumnOption('SSN',      cbSSN.Checked);
  setColumnOption('UTIL',     cbUtilization.Checked);

  if RegInfo.Name = 'VA HIV' then
    setColumnOption('RISK',   cbRisk.Checked)
  else
    setColumnOption('RISK',   False);
end;

procedure TFrameReportParameters.pnlParams030SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  cbAge.Checked         := getColumnOption('AGE');
  cbDateConf.Checked    := getColumnOption('CONFDT');
  cbDateOfBirth.Checked := getColumnOption('DOB');
  cbDateOfDeath.Checked := getColumnOption('DOD');
  cbRace.Checked        := getColumnOption('RACE');
  cbDateSel.Checked     := getColumnOption('SELDT');
  cbSex.Checked         := getColumnOption('SEX');
  cbSSN.Checked         := getColumnOption('SSN');
  cbUtilization.Checked := getColumnOption('UTIL');

  if RegInfo.Name = 'VA HIV' then
    begin
      cbRisk.Enabled    := True;
      cbRisk.Checked    := getColumnOption('RISK');
    end
  else
    begin
      cbRisk.Enabled    := False;
      cbRisk.Checked    := False;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 032 - Report Options 2 '}
///////////////////////////// Parameters Panel #032 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams032GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  setColumnOption('CSSN',     cbCSSN.Checked);
  setColumnOption('CONFDT',   cbDateConfirmed.Checked);
  setColumnOption('DOD',      cbDOD.Checked);
  setColumnOption('SELDT',    cbDateSelected.Checked);
  setColumnOption('LAST4',    cbLast4.Checked);
  setColumnOption('SELRULES', cbSelRules.Checked);
  setColumnOption('PENDCOMM', cbPendingComments.Checked);
  setColumnOption('FIRSTDIAG', cbFirstDiag.Checked);
end;

procedure TFrameReportParameters.pnlParams032Setup(const aReportCode: string);
begin
  cbPendingComments.Visible := (not RegInfo.AutoConfirm);
  cbPendingComments.Enabled := cbPendingComments.Visible;
  //-- Only display 'First Diagnosed at this Facility' option for HIV registry
  cbFirstDiag.Visible := (RegInfo.IEN = '2');
  cbFirstDiag.Enabled := (RegInfo.IEN = '2');
end;

procedure TFrameReportParameters.pnlParams032SetValues(const aReportCode: String; aList: TCustomReportParameters);
begin
  cbCSSN.Checked            := getColumnOption('CSSN');
  cbDateConfirmed.Checked   := getColumnOption('CONFDT');
  cbDOD.Checked             := getColumnOption('DOD');
  cbDateSelected.Checked    := getColumnOption('SELDT');
  cbLast4.Checked           := getColumnOption('LAST4');
  cbSelRules.Checked        := getColumnOption('SELRULES');
  cbPendingComments.Checked := getColumnOption('PENDCOMM');
  cbFirstDiag.Checked       := getColumnOption('FIRSTDIAG');
end;
{$ENDREGION}

{$REGION ' Panel 034 - Divisions '}
///////////////////////////// Parameters Panel #034 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.ccrDivisionSelectorSplitterMoved(
  Sender: TObject);
begin
  cseDivisionSearch.SetBounds(41, 0, ccrDivisionSelector.SourceList.Width-41,
    pnlDivisionSearch.ClientHeight);
end;

procedure TFrameReportParameters.cseDivisionSearchSearchStart(
  aSender: TObject; var aCommand: TCCRSearchCommand);
begin
  with cseDivisionSearch do
    SetParams([Text,'','20','']);
end;

procedure TFrameReportParameters.rbDivisionsAllClick(Sender: TObject);
begin
  rbAllClick(Sender);
  btnAllDivisions.Enabled := false;
end;

procedure TFrameReportParameters.rbDivisionsSelectedClick(Sender: TObject);
begin
  rbSelectedClick(Sender);
  if (fCurrentReport <> '4') then
    rbClinicsAll.Checked := true;
  rbPatientsAll.Checked := true;
  btnAllDivisions.Enabled := true;
end;

procedure TFrameReportParameters.pnlParams034GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, n: Integer;
  group, node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      group := GetNode('/PARAMS/DIVISIONS');
      if rbDivisionsAll.Checked then
        begin
          SetAttrVal(group, 'ALL', True);
          DeleteChildren(group);
        end
      else
        with ccrDivisionSelector do
          begin
            SetAttrVal(group, 'ALL', False);
            if ResultChanged or FullUpdate then
              begin
                DeleteChildren(group);
                n := ResultList.Items.Count - 1;
                for i:=0 to n do
                  with ResultList.Items[i] do
                    begin
                      node := AppendNode(group, 'DIV', AsString[1]);
                      SetAttrVal(node, 'ID', AsString[2]);
                    end;
                ResultChanged := False;
              end;
            if ResultList.Items.Count < 1 then
              begin
                aMsgLst.Add(RSC00208);
                aField := cseDivisionSearch;
              end;
          end;
    end;
end;

procedure TFrameReportParameters.pnlParams034Setup(const aReportCode: string);
begin
  //-- Section 508: Set the Name columns in the lists for JAWS
  if CCRScreenReaderActive then
  begin
    if pos('Available', ccrDivisionSelector.SourceList.Fields[idscName].Caption) = 0 then
    begin
      stxtDivisionsInstruct.TabStop := true;
      ccrDivisionSelector.SourceList.Fields[idscName].Caption := 'Available ' +
        ccrDivisionSelector.SourceList.Fields[idscName].Caption;
      ccrDivisionSelector.ResultList.Fields[idscName].Caption := 'Selected ' +
        ccrDivisionSelector.ResultList.Fields[idscName].Caption;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams034SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  group: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      rbDivisionsAll.Checked := True; // This also clears the selector
      group := FindNode('/PARAMS/DIVISIONS');
      if Assigned(group) and not GetAttrBool(group, 'ALL') then
        begin
          loadSelectorResult(ccrDivisionSelector, group, ['','*', 'ID']);
          if ccrDivisionSelector.ResultList.Items.Count > 0 then
            rbDivisionsSelected.Checked := True;
        end;
    end;
end;

procedure TFrameReportParameters.btnAllDivisionsClick(Sender: TObject);
begin
  cseDivisionSearch.Text := '??';
  cseDivisionSearch.Search;
end;
{$ENDREGION}

{$REGION ' Panel 035 - Type of Utilization '}
///////////////////////////// Parameters Panel #035 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams035GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  utilTypes: TDomNode;

  procedure setUtilType(const aName: String; aValue: Boolean);
    var
      node: TDomNode;
  begin
    with utilTypes.OwnerDocument do
      begin
        node := utilTypes.FindNode('UT[@ID="'+aName+'"]');
        if aValue and (node = nil) then
          begin
            node := utilTypes.appendChild(CreateElement('UT'));
            node.setAttribute('ID', aName);
          end
        else if not aValue and (node <> nil) then
          begin
            utilTypes.removeChild(node);
            DisposeNode(node);
          end;
      end;
  end;

begin
  utilTypes := TReportParameters(aList).GetNode('/PARAMS/UTIL_TYPES');

  if rbUTSelected.Checked then
    begin
      utilTypes.removeAttribute('ALL');
      setUtilType('A',  cbUTAllergy.Checked);
      setUtilType('C',  cbUTCytopathology.Checked);
      setUtilType('I',  cbUTInpatient.Checked);
      setUtilType('IP', cbUTPharmacyIP.Checked);
      setUtilType('IV', cbUTPharmacyIV.Checked);
      setUtilType('L',  cbUTLaboratory.Checked);
      setUtilType('M',  cbUTMicrobiology.Checked);
      setUtilType('O',  cbUTOutpatient.Checked);
      setUtilType('OP', cbUTPharmacyOP.Checked);
      setUtilType('R',  cbUTRadiology.Checked);
      setUtilType('SP', cbUTSurgPath.Checked);
    end
  else
    begin
      TReportParameters(aList).DeleteChildren(utilTypes);
      utilTypes.setAttribute('ALL', '1');
    end;
end;

procedure TFrameReportParameters.pnlParams035SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  utilTypes: TDomNode;

  function getUtilType(const aName: String): Boolean;
  begin
    if Assigned(utilTypes) then
      Result := (utilTypes.FindNode('UT[@ID="'+aName+'"]') <> nil)
    else
      Result := False;
  end;

begin
  utilTypes := TReportParameters(aList).FindNode('/PARAMS/UTIL_TYPES');

  if Assigned(utilTypes) and (utilTypes.getAttribute('ALL') <> '1') then
    begin
      rbUTSelected.Checked := True;
      cbUTAllergy.Checked       := getUtilType('A');
      cbUTCytopathology.Checked := getUtilType('C');
      cbUTInpatient.Checked     := getUtilType('I');
      cbUTPharmacyIP.Checked    := getUtilType('IP');
      cbUTPharmacyIV.Checked    := getUtilType('IV');
      cbUTLaboratory.Checked    := getUtilType('L');
      cbUTMicrobiology.Checked  := getUtilType('M');
      cbUTOutpatient.Checked    := getUtilType('O');
      cbUTPharmacyOP.Checked    := getUtilType('OP');
      cbUTRadiology.Checked     := getUtilType('R');
      cbUTSurgPath.Checked      := getUtilType('SP');
    end
  else
    rbUTAll.Checked := True;
end;
{$ENDREGION}

{$REGION ' Panel 042 - Investigational Drugs '}
///////////////////////////// Parameters Panel #042 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams042GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodeDrugs, 'REGSPEC',  cbRegistryDrugs042.Checked);
      SetAttrVal(NodeDrugs, 'INVESTIG', cbInvestigDrugs042.Checked);
    end
end;

procedure TFrameReportParameters.pnlParams042SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      cbRegistryDrugs042.Checked := GetAttrBool(NodeDrugs, 'REGSPEC');
      cbInvestigDrugs042.Checked := GetAttrBool(NodeDrugs, 'INVESTIG');
    end
end;
{$ENDREGION}

{$REGION ' Panel 044 - Aggregate By '}
///////////////////////////// Parameters Panel #044 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams044ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  with NodeDrugs do
    begin
      removeAttribute('AGGR_FORMUL');
      removeAttribute('AGGR_GENERIC');
    end;
end;

procedure TFrameReportParameters.pnlParams044GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodeDrugs, 'AGGR_FORMUL',  rbDispensedDrugs044.Checked);
      SetAttrVal(NodeDrugs, 'AGGR_GENERIC', rbGenericDrugs044.Checked);
    end
end;

procedure TFrameReportParameters.pnlParams044Setup(const aReportCode: string);
begin
  //-- Section 508: Set the tab stop if a screen reader is active.
  stxtAggregate044.TabStop := CCRScreenReaderActive;
end;

procedure TFrameReportParameters.pnlParams044SetValues(const aReportCode: String; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    if GetAttrBool(NodeDrugs, 'AGGR_FORMUL') then
      rbDispensedDrugs044.Checked := True
    else
      rbGenericDrugs044.Checked := True;
end;
{$ENDREGION}

{$REGION ' Panel 045 - Report Options (All Fills) '}
///////////////////////////// Parameters Panel #045 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams045GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
begin
  with TReportParameters(aList) do
  begin
    SetAttrVal(NodeOptions, 'ALL_FILLS', rbOptionsAllFills.Checked);
    SetAttrVal(NodeOptions, 'RECENT_FILLS', rbOptionsMostRecent.Checked);
  end;
end;

procedure TFrameReportParameters.pnlParams045SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
  begin
    rbOptionsAllFills.Checked := GetAttrBool(NodeOptions, 'ALL_FILLS');
    rbOptionsMostRecent.Checked := GetAttrBool(NodeOptions, 'RECENT_FILLS');
  end;
  if (not rbOptionsAllFills.Checked) and (not rbOptionsMostRecent.Checked) then
    rbOptionsAllFills.Checked := true;
end;
{$ENDREGION}

{$REGION ' Panel 046 - Utilization '}
///////////////////////////// Parameters Panel #046 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams046GetValues(const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    if rbDetailsUsers.Checked then
      begin
        SetNodeVal('/PARAMS/MAXUTNUM', edHighestUtilNum046.Text);
        if edHighestUtilNum046.Text = '' then
          begin
            aMsgLst.Add(RSC00211);
            aField := edHighestUtilNum046;
          end;
      end
    else
      DeleteNode('/PARAMS/MAXUTNUM');
end;

procedure TFrameReportParameters.pnlParams046SetValues(const aReportCode: String; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    edHighestUtilNum046.Text := GetNodeVal('/PARAMS/MAXUTNUM');
  if edHighestUtilNum046.Text <> '' then
    rbDetailsUsers.Checked := True
  else
    rbSummaryUsers.Checked := True;
end;

procedure TFrameReportParameters.rbDetailsUsersClick(Sender: TObject);
begin
  edHighestUtilNum046.Enabled := True;
end;

procedure TFrameReportParameters.rbSummaryUsersClick(Sender: TObject);
begin
  with edHighestUtilNum046 do
    begin
      Enabled := False;
      Text    := '';
    end;
end;
{$ENDREGION}

{$REGION ' Panel 047 - Result Ranges '}
///////////////////////////// Parameters Panel #047 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.setupUpperLimit(aState: boolean);
begin
  edtUpperLimitAST047.Color := CtrlColor(aState);
  edtUpperLimitAST047.Enabled := aState;
  edtUpperLimitAST047.TabStop := aState;
end;

procedure TFrameReportParameters.agLabRangesCheckBoxClick(Sender: TObject;
  ACol, ARow: Integer; State: Boolean);
var
  i, rri: Integer;
begin
  agLabRanges.HideColumn(lrgGroupCode);
  with agLabRanges do
  begin
    rri := RealRowIndex(ARow);
    if not State and (RealColIndex(ACol) = lrgToggle) then
    begin
      AllCells[lrgLow,rri]  := '';
      AllCells[lrgHigh,rri] := '';
    end;
    if (fCurrentReport = '19')  and (RealColIndex(ACol) = lrgToggle) then
    begin
      if (pos('MELD', AllCells[lrgGroupName,rri]) > 0) then
      begin
        if State then
          setupUpperLimit(false)
        else begin
          for i := agLabRanges.RowCount-1 downto agLabRanges.FixedRows do
          begin
            GetCheckBoxState(lrgToggle, i, State);
            if (pos('APRI', AllCells[lrgGroupName,i]) > 0) then
              setupUpperLimit(State);
          end;
        end;
      end
      else if (pos('APRI', AllCells[lrgGroupName,rri]) > 0) then
        setupUpperLimit(State);
    end;
  end;
end;

procedure TFrameReportParameters.agLabRangesEnter(Sender: TObject);
var i: integer;
  frm: TFormResultRanges;
  aList: TStringList;
  tmpStr, tmpStr2: String;
  state: boolean;
begin
  if CCRScreenReaderActive then
  begin
    try
      //Build a list of strings from the data in the grid
      aList := TStringList.Create;
      for i := agLabRanges.FixedRows to agLabRanges.RowCount-1 do
      begin
        agLabRanges.GetCheckBoxState(lrgToggle, i, state);
        if state then
          tmpStr := '1' + U
        else
          tmpStr := '0' + U;
        tmpStr := tmpStr + agLabRanges.AllCells[lrgGroupName, i] + U
                + agLabRanges.AllCells[lrgLow, i] + U
                + agLabRanges.AllCells[lrgHigh, i] + U;
        aList.Add(tmpStr);
      end;

      frm := TFormResultRanges.Create(aList);

      //Put the data entered on the form back into the grid
      if frm.Edit = mrOk then
      begin
        if edtUpperLimitAST047.Visible then
          setupUpperLimit(false);
        aList := frm.ListData;
        for i := 0 to aList.Count - 1 do
        begin
          tmpStr  := trim(piece(aList[i], U, 3));
          tmpStr2 := trim(piece(aList[i], U, 4));
          agLabRanges.AllCells[lrgLow, agLabRanges.FixedRows+i] := tmpStr;
          agLabRanges.AllCells[lrgHigh, agLabRanges.FixedRows+i] := tmpStr2;
          if (length(tmpStr) > 0) or (length(tmpStr2) > 0) or
             (piece(aList[i], U, 1) = '1') then
          begin
            agLabRanges.SetCheckBoxState(lrgToggle, agLabRanges.FixedRows+i, true);
            if pos('APRI', piece(aList[i], U, 2)) > 0 then
              setupUpperLimit(true);
          end
          else
            agLabRanges.SetCheckBoxState(lrgToggle, agLabRanges.FixedRows+i, false);
        end;
      end;
    finally
      aList.Clear;
      aList.Free;
      frm.Free;
    end;
    stxtLanding.SetFocus;
  end;
end;

procedure TFrameReportParameters.pnlParams047GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, checkCounter: Integer;
  group, node: TDomNode;
  state, groupApri, groupMeld: Boolean;
  low, high: String;
begin
  with TReportParameters(aList) do
  begin
    groupApri := false;
    groupMeld := false;
    checkCounter := 0;
    DeleteNode('/PARAMS/ULNAST');

    group := GetNode('/PARAMS/LRGRANGES');
    DeleteChildren(group);
    for i := agLabRanges.RowCount-1 downto agLabRanges.FixedRows do
    begin
      agLabRanges.GetCheckBoxState(lrgToggle, i, state);
      if state then
      begin
        checkCounter := checkCounter + 1;
        node := AppendNode(group, 'LRGRANGE', agLabRanges.AllCells[lrgGroupName,i]);
        SetAttrVal(node, 'USE',  '1');
        SetAttrVal(node, 'ID',   agLabRanges.GridCells[lrgGroupCode,i]);
        low  := agLabRanges.AllCells[lrgLow,i];
        high := agLabRanges.AllCells[lrgHigh,i];
        SetAttrVal(node, 'LOW',  low);
        SetAttrVal(node, 'HIGH', high);
        if not checkRange(low, high) then
        begin
          aMsgLst.Add(RSC00212);
          aField := agLabRanges;
          Break;
        end;

        //-- Special processing for the Liver score report
        if (aReportCode = '19') then
        begin
          if checkCounter > 2 then
          begin
            aMsgLst.Add(RSC00261);
            aField := agLabRanges;
          end;
          if (agLabRanges.GridCells[lrgGroupName,i] = 'APRI') or
             (agLabRanges.GridCells[lrgGroupName,i] = 'FIB-4') then
            groupApri := true;
          if (pos('MELD', agLabRanges.GridCells[lrgGroupName,i]) > 0) then
            groupMeld := true;
          if (agLabRanges.GridCells[lrgGroupName,i] = 'APRI') and
             (edtUpperLimitAST047.Text = '') then
          begin
            aMsgLst.Add(RSC00262);
            aField := edtUpperLimitAST047;
          end
          else if not groupMeld then
            SetNodeVal('/PARAMS/ULNAST', edtUpperLimitAST047.Text);
        end;
      end;
    end;

    if (aReportCode = '19') and groupApri and groupMeld then
    begin
      aMsgLst.Add(RSC00263);
      aField := agLabRanges;
    end;
    if (aReportCode = '19') and (checkCounter < 1) then
    begin
      aMsgLst.Add(RSC00264);
      aField := agLabRanges;
    end;

  end;
end;

procedure TFrameReportParameters.pnlParams047Setup(const aReportCode: string);
begin
  stxtLiverTests047.Visible := false;
  pnlAST.Visible := false;
  pnlAST.Height := 0;
  edtUpperLimitAST047.Enabled := false;
  edtUpperLimitAST047.TabStop := false;
  if (aReportCode = '10') then
  begin
    loadResultRangeGrid(agLabRanges, fRegTests, 'Lab Test Group', true);
    stxtInstruct047.Caption := 'For this report to work, lists of registry-specific Lab '
      + 'tests (Lab Tests tab of the Site Parameters) must be current!';
    stxtInstruct047.Height := 30;
    pnlParams047.HelpContext := 530;
  end
  else if (aReportCode = '18') then
  begin
    loadResultRangeGrid(agLabRanges, fBMITests, 'BMI Range', true);
    stxtInstruct047.Caption := '';
    stxtInstruct047.Height := 13;
    pnlParams047.HelpContext := 582;
  end
  else if (aReportCode = '19') then
  begin
    loadResultRangeGrid(agLabRanges, fLiverTests, 'Liver Score Range', true);
    stxtInstruct047.Caption := 'Lab tests used in calculations are identified '
      + 'by LOINC code. If the values shown for test results appear unusual, '
      + 'contact your local Lab ADPAC to verify that LOINC codes are set up '
      + 'correctly.';
    stxtInstruct047.Height := 30;
    pnlParams047.HelpContext := 583;
    stxtLiverTests047.Visible := true;
    pnlAST.Visible := true;
    pnlAST.Height := 25;
    edtUpperLimitAST047.Color := CtrlColor(false);
  end
  else if (aReportCode = '20') then
  begin
    loadResultRangeGrid(agLabRanges, fRenalTests, 'Renal Function Range', true);
    stxtInstruct047.Caption := 'Lab tests used to calculate renal function are '
      + 'identified by LOINC code. If the values shown for test results appear '
      + 'unusual, contact your local Lab ADPAC to verify that LOINC codes are '
      + 'set up correctly.';
    stxtInstruct047.Height := 30;
    pnlParams047.HelpContext := 584;
  end;
  pnlInstruct047.Height := stxtInstruct047.Height + 6;
  pnlParams047.Height := agLabRanges.Height + pnlAST.Height
    + pnlInstruct047.Height + 19;
  //-- Section 508: Set the tab stop if a screen reader is active.
  stxtLiverTests047.TabStop := CCRScreenReaderActive;
  stxtInstruct047.TabStop := CCRScreenReaderActive and (stxtInstruct047.Caption <> '');
  stxtUpperLimitAST.TabStop := CCRScreenReaderActive and (pnlAST.Visible);
  //-- Section 508: Create landing for return from 508 data entry form
  if CCRScreenReaderActive then
    pnlParams047.Height := pnlParams047.Height + 25;
  pnlLanding.Enabled := CCRScreenReaderActive;
  pnlLanding.Visible := pnlLanding.Enabled;
end;

procedure TFrameReportParameters.pnlParams047SetValues(const aReportCode: String;
  aList: TCustomReportParameters);

procedure clearItem(const aRow: Integer);
begin
  with agLabRanges do
    begin
      SetCheckBoxState(lrgToggle, aRow, False);
      AllCells[lrgLow,aRow]  := '';
      AllCells[lrgHigh,aRow] := '';
    end;
end;

var
  i: Integer;
  group, node: TDomNode;
  query, val: String;
begin
  if agLabRanges.RowCount > 1 then
  begin
    agLabRanges.BeginUpdate;
    with TReportParameters(aList) do
      try
        group := FindNode('/PARAMS/LRGRANGES');
        if Assigned(group) then
          for i:=agLabRanges.RowCount-1 downto agLabRanges.FixedRows do
          begin
            query := 'LRGRANGE[@ID=' + agLabRanges.AllCells[lrgGroupCode,i] + ']';
            node := group.FindNode(query);
            if Assigned(node) then
              with agLabRanges do
              begin
                val := node.getAttribute('USE');
                SetCheckBoxState(lrgToggle, i, StrToBoolDef(val,False));
                AllCells[lrgLow, i]  := node.getAttribute('LOW');
                AllCells[lrgHigh, i] := node.getAttribute('HIGH');
              end
            else
              clearItem(i);
          end
        else
          for i:=agLabRanges.RowCount-1 downto agLabRanges.FixedRows do
            clearItem(i);
        // For the Liver Score report, set the upper limit of normal value
        if aReportCode = '19' then
        begin
          edtUpperLimitAST047.Text := GetNodeVal('/PARAMS/ULNAST');
          if edtUpperLimitAST047.Text <> '' then
          begin
            edtUpperLimitAST047.Enabled := true;
            edtUpperLimitAST047.TabStop := true;
            edtUpperLimitAST047.Color := CtrlColor(true);
          end;
        end;
      finally
        agLabRanges.EndUpdate;
      end;
    end
  else begin
    pnlParams047.Align   := alBottom;
    pnlParams047.Visible := False;
  end;
end;

procedure TFrameReportParameters.edtUpperLimitAST047KeyPress(Sender: TObject;
  var Key: Char);
begin
  if (not (Key in ['0'..'9',#8])) then
    Key := #0;
end;
{$ENDREGION}

{$REGION ' Panel 050 - Clinics '}
///////////////////////////// Parameters Panel #050 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.ccrClinicSelectorSplitterMoved(
  Sender: TObject);
begin
  cseClinicSearch.SetBounds(41, 0, ccrClinicSelector.SourceList.Width-41,
    pnlClinicSearch.ClientHeight);
end;

procedure TFrameReportParameters.cseClinicSearchSearchStart(
  aSender: TObject; var aCommand: TCCRSearchCommand);
begin
  with cseClinicSearch do
    SetParams(['C','0',cseClinicSearch.Text,'AI','20','']);
end;

procedure TFrameReportParameters.rbClinicsAllClick(Sender: TObject);
begin
  rbAllClick(Sender);
end;

procedure TFrameReportParameters.rbClinicsSelectedClick(Sender: TObject);
begin
  rbSelectedClick(Sender);
  if (fCurrentReport <> '4') then
  begin
    rbDivisionsAll.Checked := true;
    rbPatientsAll.Checked := true;
  end;
end;

procedure TFrameReportParameters.pnlParams050GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, n: Integer;
  group, node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      group := GetNode('/PARAMS/CLINICS');
      if rbClinicsAll.Checked then
        begin
          SetAttrVal(group, 'ALL', True);
          DeleteChildren(group);
        end
      else
        with ccrClinicSelector do
          begin
            SetAttrVal(group, 'ALL', False);
            if ResultChanged or FullUpdate then
              begin
                DeleteChildren(group);
                n := ResultList.Items.Count - 1;
                for i:=0 to n do
                  with ResultList.Items[i] do
                    begin
                      node := AppendNode(group, 'CLINIC', AsString[1]);
                      SetAttrVal(node, 'ID', AsString[2]);
                    end;
                ResultChanged := False;
              end;
            if ResultList.Items.Count < 1 then
              begin
                aMsgLst.Add(RSC00214);
                aField := cseClinicSearch;
              end;
          end;
    end;
end;

procedure TFrameReportParameters.pnlParams050Setup(const aReportCode: string);
begin
  stxtClinicsInstruct.Visible := (aReportCode <> '4');
  //-- Section 508: Set the Name columns in the lists for JAWS
  if CCRScreenReaderActive then
  begin
    stxtClinicsInstruct.TabStop := stxtClinicsInstruct.Visible;
    if pos('Available', ccrClinicSelector.SourceList.Fields[idscName].Caption) = 0 then
    begin
      ccrClinicSelector.SourceList.Fields[idscName].Caption := 'Available ' +
        ccrClinicSelector.SourceList.Fields[idscName].Caption;
      ccrClinicSelector.ResultList.Fields[idscName].Caption := 'Selected ' +
        ccrClinicSelector.ResultList.Fields[idscName].Caption;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams050SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  group: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      rbClinicsAll.Checked := True; // This also clears the selector
      group := FindNode('/PARAMS/CLINICS');
      if Assigned(group) and not GetAttrBool(group, 'ALL') then
        begin
          loadSelectorResult(ccrClinicSelector, group, ['','*', 'ID']);
          if ccrClinicSelector.ResultList.Items.Count > 0 then
            rbClinicsSelected.Checked := True;
        end;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 052 - Lab Tests '}
///////////////////////////// Parameters Panel #052 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.ccrLabTestSelectorSplitterMoved(
  Sender: TObject);
begin
  cseLabTestSearch.SetBounds(41, 0, ccrLabTestSelector.SourceList.Width-41,
    pnlLabTestSearch.ClientHeight);
end;

procedure TFrameReportParameters.cseLabTestSearchSearchStart(
  aSender: TObject; var aCommand: TCCRSearchCommand);
begin
  with cseLabTestSearch do
    SetParams(['',cseLabTestSearch.Text,'P','','']);
end;

procedure TFrameReportParameters.pnlParams052ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  TReportParameters(aList).DeleteNode('/PARAMS/LABTESTS');
end;

procedure TFrameReportParameters.pnlParams052GetValues(const aReportCode: String; aList: TCustomReportParameters;
   aMsgLst: TStrings; var aField: TWinControl);
var
  i, n: Integer;
  group, node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      group := GetNode('/PARAMS/LABTESTS');
      if rbLabTestsAll.Checked then
        begin
          SetAttrVal(group, 'ALL', True);
          DeleteChildren(group);
        end
      else
        with ccrLabTestSelector do
          begin
            SetAttrVal(group, 'ALL', False);
            if ResultChanged or FullUpdate then
              begin
                DeleteChildren(group);
                n := ResultList.Items.Count - 1;
                for i:=0 to n do
                  with ResultList.Items[i] do
                    begin
                      node := AppendNode(group, 'LT', AsString[1]);
                      SetAttrVal(node, 'ID', AsString[3]);
                    end;
                ResultChanged := False;
              end;
            if ResultList.Items.Count < 1 then
              begin
                aMsgLst.Add(RSC00215);
                aField := cseLabTestSearch;
              end;
          end;
    end;
end;

procedure TFrameReportParameters.pnlParams052Setup(const aReportCode: String);
begin
  if aReportCode = '12' then  // Combined Rx and Lab report
  begin
    rbLabTestsAll.Visible      := False;
    rbLabTestsSelected.Visible := False;
    rbLabTestsSelected.Checked := True;
  end
  else begin
    rbLabTestsAll.Visible      := True;
    rbLabTestsSelected.Visible := True;
  end;
  //-- Section 508: Set the Name columns in the lists for JAWS
  if CCRScreenReaderActive then
  begin
    if pos('Available', ccrLabTestSelector.SourceList.Fields[idscName].Caption) = 0 then
    begin
      ccrLabTestSelector.SourceList.Fields[idscName].Caption := 'Available ' +
        ccrLabTestSelector.SourceList.Fields[idscName].Caption;
      ccrLabTestSelector.ResultList.Fields[idscName].Caption := 'Selected ' +
        ccrLabTestSelector.ResultList.Fields[idscName].Caption;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams052SetValues(const aReportCode: String; aList: TCustomReportParameters);
var
  group: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      rbLabTestsAll.Checked := True; // This also clears the selector
      group := FindNode('/PARAMS/LABTESTS');
      if Assigned(group) and not GetAttrBool(group, 'ALL') then
        begin
          loadSelectorResult(ccrLabTestSelector, group, ['','*','','ID']);
          if ccrLabTestSelector.ResultList.Items.Count > 0 then
            rbLabTestsSelected.Checked := True;
        end;
      if aReportCode = '12' then  // Combined Rx and Lab report
        rbLabTestsSelected.Checked := True;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 053 - Lab Tests Ranges '}
///////////////////////////// Parameters Panel #053 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.ccrLTRSelectorResultListCanEditCell(
  Sender: TObject; ARow, ACol: Integer; var CanEdit: Boolean);
begin
  with ccrLTRSelector.ResultList do
    if ARow >= FixedRows then
      CanEdit := not StrToBoolDef(GridCells[ltrPanel,RealRowIndex(ARow)], False);
end;

procedure TFrameReportParameters.ccrLTRSelectorResultListColumnSize(
  Sender: TObject; ACol: Integer; var Allow: Boolean);
begin
  Allow := ACol <> 0;
end;

procedure TFrameReportParameters.ccrLTRSelectorResultListCustomCompare(
  Sender: TObject; str1, str2: String; var Res: Integer);
var
  val1, val2: Double;
  mode: Integer;
begin
  res := 0;
  if str1 <> str2 then
    begin
      mode := 0;
      try
        val1 := StrToFloat(str1);
        Inc(mode,1);
      except
        val1 := 0;
      end;
      try
        val2 := StrToFloat(str2);
        Inc(mode,2);
      except
        val2 := 0;
      end;
      case mode of
      1:    //--- Number ]] String
        res := -1;
      2:    //--- Number ]] String
        res := 1;
      3:    //--- Both numeric
        if val1 > val2 then
          res := 1
        else if val1 < val2 then
          res := -1;
      else  //--- Both strings
        res := AnsiCompareText(str1, str2);
      end;
    end;
end;

procedure TFrameReportParameters.ccrLTRSelectorResultListGetDisplText(
  Sender: TObject; ACol, ARow: Integer; var Value: String);
begin
  with ccrLTRSelector.ResultList do
    if (ARow >= FixedRows) and (ACol = ltrPanel) then
      if (Value <> '0') and (Value <> '') then
        Value := 'P'
      else
        Value := ' ';
end;

procedure TFrameReportParameters.ccrLTRSelectorSplitterMoved(
  Sender: TObject);
begin
  cseLTRSearch.SetBounds(41, 0, ccrLTRSelector.SourceList.Width-41,
    pnlLTRSearch.ClientHeight);
end;

procedure TFrameReportParameters.cseLTRSearchSearchStart(aSender: TObject;
  var aCommand: TCCRSearchCommand);
begin
  with cseLTRSearch do
    SetParams(['',cseLTRSearch.Text,'P','','']);
end;

procedure TFrameReportParameters.pnlParams053ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  TReportParameters(aList).DeleteNode('/PARAMS/LABTESTS');
end;

procedure TFrameReportParameters.pnlParams053GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, n: Integer;
  group, node: TDomNode;
  params: TReportParameters;
  val: String;
begin
  params := TReportParameters(aList);
  group := params.GetNode('/PARAMS/LABTESTS');
  if rbLTRMostRecent.Checked then
      params.SetAttrVal(group, 'MOST_RECENT', '1')
  else
      params.SetAttrVal(group, 'MOST_RECENT', '0');
  if rbLTRAll.Checked then
    begin
      params.SetAttrVal(group, 'ALL', True);
      params.DeleteChildren(group);
    end
  else
    with ccrLTRSelector do
      begin
        params.SetAttrVal(group, 'ALL', False);
        if ResultChanged or FullUpdate then
          begin
            params.DeleteChildren(group);
            n := ResultList.RowCount - 1;
            for i:=ResultList.FixedRows to n do
              begin
                node := params.AppendNode(group, 'LT', ResultList.AllCells[ltrName,i]);
                params.SetAttrVal(node, 'ID', ResultList.AllCells[ltrIEN,i]);
                val := ResultList.GridCells[ltrPanel,i];
                if StrToBoolDef(val, False) then
                  params.SetAttrVal(node, 'P', val);
                //--- Optional result range
                val := ResultList.AllCells[ltrLow,i];
                if val <> '' then
                  params.SetAttrVal(node, 'LOW', val);
                val := ResultList.AllCells[ltrHigh,i];
                if val <> '' then
                  params.SetAttrVal(node, 'HIGH', val);
              end;
            ResultChanged := False;
          end;
        if ResultList.RowCount <= ResultList.FixedRows then
          begin
            aMsgLst.Add(RSC00215);
            aField := cseLTRSearch;
          end;
      end;
end;

procedure TFrameReportParameters.pnlParams053Setup(const aReportCode: String);
begin
  // Combined Rx and Lab or DAA Lab Monitoring reports
  if (aReportCode = '12') or (aReportCode = '22') then
  begin
    rbLTRAll.Visible      := True;
    rbLTRSelected.Visible := True;
    rbLTRSelected.Checked := True;
    rbLTRMostRecentAll.Visible := True;
    rbLTRMostRecentAll.Checked := True;
    rbLTRMostRecent.Visible := True;
  end
  else begin
    rbLTRAll.Visible      := False;
    rbLTRSelected.Visible := False;
    rbLTRMostRecentAll.Visible := False;
    rbLTRMostRecentAll.Checked := True;
    rbLTRMostRecent.Visible := False;
  end;
  //-- Section 508: Set the Name columns in the lists for JAWS
  if CCRScreenReaderActive then
  begin
    if pos('Available', ccrLTRSelector.SourceList.Fields[ltrName].Caption) = 0 then
    begin
      ccrLTRSelector.SourceList.Fields[ltrName].Caption := 'Available ' +
        ccrLTRSelector.SourceList.Fields[ltrName].Caption;
    end;
  end
  else
    ccrLTRSelector.ResultList.Columns[ltrName].Header := 'Name';
end;

procedure TFrameReportParameters.pnlParams053SetValues(
  const aReportCode: String; aList: TCustomReportParameters);
var
  group: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      rbLTRAll.Checked := True; // This also clears the selector
      group := FindNode('/PARAMS/LABTESTS');
      if Assigned(group) and not GetAttrBool(group, 'ALL') then
        with ccrLTRSelector do
          begin
            loadSelectorGridResult(ccrLTRSelector, group, ['DUMMY508', '*', 'P', 'LOW','HIGH','ID']);
            if ResultList.RowCount > ResultList.FixedRows then
              rbLTRSelected.Checked := True;
          end;
      if aReportCode = '12' then  // Combined Rx and Lab report
        rbLTRSelected.Checked := True;
      if Assigned(group) and GetAttrBool(group, 'MOST_RECENT') then
        rbLTRMostRecent.Checked := True
      else
        rbLTRMostRecentAll.Checked := True;
    end;
end;

procedure TFrameReportParameters.pnlParams053ConstrainedResize(
  Sender: TObject; var MinWidth, MinHeight, MaxWidth, MaxHeight: Integer);
begin
  rbLTRMostRecentAll.Left := ccrLTRSelector.ResultList.Left - 3;
  rbLTRMostRecent.Left := rbLTRMostRecentAll.Left + 87;
end;
{$ENDREGION}

{$REGION ' Panel 054 - Medications '}
///////////////////////////// Parameters Panel #054 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.acDrugGroupAddExecute(Sender: TObject);
var
  gn: PVirtualNode;
begin
  with ccrDrugSelector.ResultTree do
    begin
      if edDrugGroupName.Text = '' then
      begin
        MessageDlg508('', RSC00224, mtWarning, [mbOK], 0);
        edDrugGroupName.SetFocus;
      end
      else if FindGroup(edDrugGroupName.Text) = nil then
        begin
          gn := AddGroup(edDrugGroupName.Text);
          if Assigned(gn) then
            begin
              FocusedNode := gn;
              ClearSelection;
              Selected[gn] := True;
            end;
        end
      else
        MessageDlg508('', Format(RSC00222,[edDrugGroupName.Text]), mtWarning, [mbOK], 0);
    end;
end;

procedure TFrameReportParameters.acDrugGroupDeleteExecute(Sender: TObject);
var
  next, node: PVirtualNode;
  rc: Word;
begin
  with ccrDrugSelector.ResultTree do
    begin
      rc := mrNo;
      next := GetFirstChild(RootNode);
      while Assigned(next) do
        begin
          node := next;
          next := GetNextSibling(node);
          if Selected[node] then
            begin
              if rc <> mrYesToAll then
                begin
                  // DEBUG(ETM) - was MessageDialog (default = mrNo)
                  rc := MessageDlg508(rscReportParameters,
                          Format(RSC00223,[AsString[node,idscName]]),
                          mtConfirmation, [mbYes,mbNo,mbYesToAll,mbCancel], 0);
                  if rc = mrCancel then
                    Break;
                end;
              if (rc = mrYesToAll) or (rc = mrYes) then
                DeleteGroup(node);
            end;
        end;
    end;
end;

procedure TFrameReportParameters.ccrDrugSelectorResultListKeyAction(
  Sender: TBaseVirtualTree; var CharCode: Word; var Shift: TShiftState;
  var DoDefault: Boolean);
begin
  if (Shift = []) and (CharCode = VK_DELETE) then
    begin
      acDrugGroupDelete.Execute;
      DoDefault := False;
    end;
end;

procedure TFrameReportParameters.ccrDrugSelectorSplitterMoved(
  Sender: TObject);
begin
  pnlDrugSearch054.DisableAlign;
  try
    with cmbxDrugSearch054 do
      cseDrugSearch.SetBounds(Width, 17, ccrDrugSelector.SourceList.Width - Width, Height);
    pnlDrugGroup.Width  := ccrDrugSelector.ResultTree.Width;
    stxtSearch054.Left := cseDrugSearch.Left;
    stxtGroupName054.Left := pnlDrugSearch054.Width - pnlDrugGroup.Width;
  finally
    pnlDrugSearch054.EnableAlign;
  end;
end;

procedure TFrameReportParameters.cmbxDrugSearch054Select(Sender: TObject);
begin
  with ccrDrugSelector do
    begin
      case cmbxDrugSearch054.ItemIndex of
        0:    // Individual Formulations
          begin
            SourceType := idstFormulation;
            SourceList.Fields[idscDrugCode].Visible := False;
          end;
        1:    // Generic Names
          begin
            SourceType := idstGeneric;
            SourceList.Fields[idscDrugCode].Visible := False;
          end;
        4:    // Registry Medications
          begin
            SourceType := idstGeneric;
            SourceList.Fields[idscDrugCode].Visible := False;
          end;
        5:    // Investigational Drugs
          begin
            SourceType := idstGeneric;
            SourceList.Fields[idscDrugCode].Visible := False;
          end;
        else  // Drug Classes
          begin
            SourceType := idstDrugClass;
            SourceList.Fields[idscDrugCode].Visible := True;
          end;
      end;
      SourceList.Clear;
    end;
end;

procedure TFrameReportParameters.cseDrugSearchSearchStart(
  aSender: TObject; var aCommand: TCCRSearchCommand);
begin
  //-- Section 508: Added -99 to the beginning of all the search fields so JAWS
  //   will recognize the first column. Moved the IEN column (1) from the first
  //   column (0) to the third column (2).
  with cseDrugSearch do
    case cmbxDrugSearch054.ItemIndex of
      0:  // Individual Formulations
        begin
          SearchFields := '-99,2,1';
          SearchRPCName := rpcListDrugs;
          SetParams([cseDrugSearch.Text,'','','']);
        end;
      1:  // Generic Names
        begin
          SearchFields := '-99,2,1';
          SearchRPCName := rpcListDrugs;
          SetParams([cseDrugSearch.Text,'G','','']);
        end;
      2:  // VA Drug Class Codes
        begin
          SearchFields := '-99,2,1,3';
          SearchRPCName := rpcListVADrugClasses;
          SetParams(['',cseDrugSearch.Text,'','','']);
        end;
      3:  // VA Drug Class Names
        begin
          SearchFields := '-99,2,1,3';
          SearchRPCName := rpcListVADrugClasses;
          SetParams(['',cseDrugSearch.Text,'N','','']);
        end;
      4:  // Registry Medications
        begin
          SearchFields := '-99,2,1';
          SearchRPCName := rpcListRegistryDrugs;
          SetParams([cseDrugSearch.Text,RegInfo.IEN,'','']);
        end;
      5:  // Investigational Drugs
        begin
          SearchFields := '-99,2,1';
          SearchRPCName := rpcListInvestigDrugs;
          SetParams([cseDrugSearch.Text,RegInfo.IEN,'','']);
        end;
    end;
end;

procedure TFrameReportParameters.edDrugGroupNameKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (Shift = []) and (Key = VK_RETURN) then
    acDrugGroupAdd.Execute;
end;

procedure TFrameReportParameters.pnlDrugGroupResize(Sender: TObject);
begin
  with pnlDrugGroup do
    begin
      edDrugGroupName.SetBounds(0, 0, ClientWidth - 2*ClientHeight, ClientHeight);
      spbDrugGroupAdd.SetBounds(edDrugGroupName.Width, 0, ClientHeight, ClientHeight);
      spbDrugGroupDelete.SetBounds(edDrugGroupName.Width+ClientHeight, 0,
        ClientHeight, ClientHeight);
    end;
end;

procedure TFrameReportParameters.pnlParams054ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  TReportParameters(aList).DeleteChildren(NodeDrugs);
end;

procedure TFrameReportParameters.pnlParams054GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);

  function section(srcSection: PVirtualNode; dstGroup: TDomNode): TDomNode;
  var
    srcItem: PVirtualNode;
    dstItem: TDomNode;
    empty: Boolean;
    sectionType: Integer;
    itemName: String;
    params: TReportParameters;
  begin
    params := TReportParameters(aList);
    with ccrDrugSelector.ResultTree do
      begin
        empty := True;
        sectionType := AsInteger[srcSection,idscType];
        case sectionType of
          idstDrugClass:
            Result := params.AppendNode(dstGroup, 'VARXCLS');
          idstFormulation:
            Result := params.AppendNode(dstGroup, 'FORMULATIONS');
          idstGeneric:
            Result := params.AppendNode(dstGroup, 'GENERIC');
          else
            Result := nil;
        end;

        if Assigned(Result) then
          begin
            srcItem := GetFirstChild(srcSection);
            while Assigned(srcItem) do
              begin
                itemName := AsString[srcItem,idscName];
                if sectionType = idstDrugClass then
                  begin
                    dstItem := params.AppendNode(Result, 'VARXCL', itemName);
                    params.SetAttrVal(dstItem, 'CODE', AsString[srcItem,idscDrugCode]);
                  end
                else
                  dstItem := params.AppendNode(Result, 'DRUG', itemName);
               params.SetAttrVal(dstItem, 'ID', AsString[srcItem,idscIEN]);
               empty := False;
                srcItem := GetNextSibling(srcItem);
              end;

            if empty then
              begin
                params.DeleteNode(Result);
                Result := nil;
              end;
          end;
      end;
  end;

  function group(srcGroup: PVirtualNode; dstNode: TDomNode): TDomNode;
  var
    srcSection: PVirtualNode;
    empty: Boolean;
    params: TReportParameters;
  begin
    params := TReportParameters(aList);
    with ccrDrugSelector.ResultTree do
      begin
        empty := True;
        Result := params.AppendNode(dstNode, 'GROUP');
        params.SetAttrVal(Result, 'ID', AsString[srcGroup,idscName]);

        srcSection := GetFirstChild(srcGroup);
        while Assigned(srcSection) do
          begin
            if section(srcSection, Result) <> nil then
              empty := False;
            srcSection := GetNextSibling(srcSection);
          end;

        if empty then
          begin
            params.DeleteNode(Result);
            Result := nil;
          end;
      end;
  end;

var
  srcGroup: PVirtualNode;
  empty: Boolean;
  params: TReportParameters;
begin
  params := TReportParameters(aList);
  with ccrDrugSelector do
    begin
      if rbDrugsAll.Checked then
        begin
          params.SetAttrVal(NodeDrugs, 'ALL', True);
          params.DeleteChildren(NodeDrugs);
        end
      else
        begin
          empty := True;
          params.SetAttrVal(NodeDrugs, 'ALL', False);
          if ResultChanged or FullUpdate then
            begin
              params.DeleteChildren(NodeDrugs);
              srcGroup := ResultTree.GetFirstChild(nil);
              while Assigned(srcGroup) do
                begin
                  if group(srcGroup, NodeDrugs) <> nil then
                    empty := False;
                  srcGroup := ResultTree.GetNextSibling(srcGroup);
                end;

              ResultChanged := False;
            end;
          if empty then
            begin
              aMsgLst.Add(RSC00209);
              aField := cseDrugSearch;
            end;
        end;
    end;
end;

procedure TFrameReportParameters.pnlParams054Setup(const aReportCode: String);
begin
  acDrugGroupAdd.Enabled    := True;
  acDrugGroupDelete.Enabled := True;
  pnlDrugGroup.Visible      := True;
  stxtSearch054.Left := cseDrugSearch.Left;
  stxtGroupName054.Left := pnlDrugSearch054.Width - pnlDrugGroup.Width;

  //-- Section 508: Set the first column ("Dummy508" ) width to 1 and change
  //   the name columns.
  ccrDrugSelector.ResultTree.Header.Columns[0].Width := 1;
  if CCRScreenReaderActive then
  begin
    if pos('Available', ccrDrugSelector.SourceList.Fields[idscName].Caption) = 0 then
    begin
      ccrDrugSelector.SourceList.Fields[idscName].Caption := 'Available ' +
        ccrDrugSelector.SourceList.Fields[idscName].Caption;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams054SetValues(const aReportCode: String;
  aList: TCustomReportParameters);

  function section(srcSection: TDomNode; dstGroup: PVirtualNode): PVirtualNode;
  var
    srcItem: TDomNode;
    aName: String;
    dstItem: PVirtualNode;
    empty: Boolean;
    params: TReportParameters;
    sectionType: Integer;
  begin
    params := TReportParameters(aList);
    empty := True;
    sectionType := 0;
    Result := nil;
    with ccrDrugSelector.ResultTree do
      begin
        aName := srcSection.NodeName;
        if aName = 'FORMULATIONS' then
          sectionType := idstFormulation
        else if aName = 'GENERIC' then
          sectionType := idstGeneric
        else if aName = 'VARXCLS' then
          sectionType := idstDrugClass;

        if sectionType > 0 then
          Result := GetSection(dstGroup, sectionType);

        if Assigned(Result) then
          begin
            srcItem := srcSection.FirstChild;
            while Assigned(srcItem) do
              begin
                aName := params.GetNodeVal(srcItem);
                if aName <> '' then
                  begin
                    dstItem := AddItem(Result, aName);
                    AsString[dstItem,idscIEN] := params.GetAttrStr(srcItem, 'ID');
                    if sectionType = idstDrugClass then
                      AsString[dstItem,idscDrugCode] := params.GetAttrStr(srcItem, 'CODE');
                    empty := False;
                  end;
                srcItem := srcItem.NextSibling;
              end;
            if empty then
              Result := nil;
          end;
      end;
  end;

  function group(srcGroup: TDomNode): PVirtualNode;
  var
    srcSection: TDomNode;
    params: TReportParameters;
    empty: Boolean;
    grpName: String;
  begin
    params := TReportParameters(aList);
    empty := True;
    with ccrDrugSelector.ResultTree do
      begin
        grpName := params.GetAttrStr(srcGroup, 'ID');
        if grpName <> '' then
          begin
            Result := FindGroup(grpName);
            if not Assigned(Result) then
              Result := AddGroup(grpName);
          end
        else
          Result := nil;
        if Assigned(Result) then
          begin
            //--- Regular sections
            srcSection := srcGroup.FirstChild;
            while Assigned(srcSection) do
              begin
                if section(srcSection, Result) <> nil then
                  empty := False;
                srcSection := srcSection.NextSibling;
              end;
          end;
      if empty then
        begin
          DeleteGroup(Result);
          Result := nil;
        end;
      end;
  end;

var
  srcGroup: TDomNode;
  params: TReportParameters;
  empty: Boolean;
begin
  params := TReportParameters(aList);
  with ccrDrugSelector do
    begin
      ResultTree.BeginUpdate;
      try
        rbDrugsAll.Checked := True; // This also clears the selector
        if Assigned(NodeDrugs) and not params.GetAttrBool(NodeDrugs, 'ALL') then
          begin
            empty := True;
            srcGroup := NodeDrugs.FirstChild;
            while Assigned(srcGroup) do
              begin
                if group(srcGroup) <> nil then
                  empty := False;
                srcGroup := srcGroup.NextSibling;
              end;
            if not empty then
              rbDrugsSelected.Checked := True
            else
              Clear;
          end;
      finally
        ResultTree.EndUpdate;
      end;

      ResultChanged := False;
    end;
end;

procedure TFrameReportParameters.ccrDrugSelectorAdd(Sender: TObject);
begin
  if ccrDrugSelector.ResultTree.GetFirstChild(ccrDrugSelector.ResultTree.RootNode) = nil then
  begin
    MessageDlg508('', RSC00226, mtWarning, [mbOK], 0);
    edDrugGroupName.SetFocus;
  end
  else
    inherited;
end;

procedure TFrameReportParameters.ccrDrugSelectorAddAll(Sender: TObject);
begin
  if ccrDrugSelector.ResultTree.GetFirstChild(ccrDrugSelector.ResultTree.RootNode) = nil then
  begin
    MessageDlg508('', RSC00226, mtWarning, [mbOK], 0);
    edDrugGroupName.SetFocus;
  end
  else
    inherited;
end;

procedure TFrameReportParameters.rbDrugsAllClick(Sender: TObject);
begin
  rbAllClick(Sender);
  btnAllRegistryMeds.Enabled := false;
end;

procedure TFrameReportParameters.rbDrugsSelectedClick(Sender: TObject);
begin
  rbSelectedClick(Sender);
  btnAllRegistryMeds.Enabled := true;
end;

procedure TFrameReportParameters.btnAllRegistryMedsClick(Sender: TObject);
begin
  cmbxDrugSearch054.ItemIndex := 4;   //Registry medications
  cmbxDrugSearch054Select(Sender);
  cseDrugSearch.Text := '??';
  cseDrugSearch.Search;
end;
{$ENDREGION}

{$REGION ' Panel 056 - Investigational Drugs '}
///////////////////////////// Parameters Panel #056 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams056GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    SetAttrVal(NodeDrugs, 'INVESTIG', cbInvestigDrugs056.Checked);
end;

procedure TFrameReportParameters.pnlParams056SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    cbInvestigDrugs056.Checked := GetAttrBool(NodeDrugs, 'INVESTIG');
end;
{$ENDREGION}

{$REGION ' Panel 058 - ICD-9 (OLD) '}
///////////////////////////// Parameters Panel #058 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.ccrICD9SelectorSplitterMoved(
  Sender: TObject);
begin
  with cmbbICD9Search do
    cseICD9Search.SetBounds(Width, 0,
      ccrICD9Selector.SourceList.Width - Width, Height);
end;

procedure TFrameReportParameters.cseICD9SearchSearchStart(aSender: TObject;
  var aCommand: TCCRSearchCommand);
var
  flags: String;
begin
  if cmbbICD9Search.ItemIndex = 1 then
    flags := 'D'
  else
    flags := '';
  with cseICD9Search do
    SetParams(['',Text,flags,'20','']);
end;

procedure TFrameReportParameters.pnlParams058GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, n: Integer;
  group, node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      // group := GetNode('/PARAMS/ICD9LST'); // ICD-10 Remediation. ROR*1.5*19 2012-01-10. Commented
      group := GetNode(nxml_PARAMS_ICDLST);   // ICD-10 Remediation. ROR*1.5*19 2012-01-10. 
      if rbICD9All.Checked then
        begin
          SetAttrVal(group, 'ALL', True);
          DeleteChildren(group);
        end
      else
        with ccrICD9Selector do
          begin
            SetAttrVal(group, 'ALL', False);
            if ResultChanged or FullUpdate then
              begin
                DeleteChildren(group);
                n := ResultList.Items.Count - 1;
                for i:=0 to n do
                  with ResultList.Items[i] do
                    begin
                      node := AppendNode(group, nxmlICDNode, AsString[1]);// ICD-10 Remediation. ROR*1.5*19 2013-05-01
                      SetAttrVal(node, 'ID',  AsString[0]);
                    end;
                ResultChanged := False;
              end;
            if ResultList.Items.Count < 1 then
              begin
                aMsgLst.Add(RSC00216);
                aField := cseICD9Search;
              end;
          end;
    end;
end;

procedure TFrameReportParameters.pnlParams058SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  group: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      rbICD9All.Checked := True; // This also clears the selector
//      group := FindNode('/PARAMS/ICD9LST'); // ICD-10 Remediation. ROR*1.5*19 2012-01-10. 
      group := FindNode(nxml_PARAMS_ICDLST);  // ICD-10 Remediation. ROR*1.5*19 2012-01-10
      if Assigned(group) and not GetAttrBool(group, 'ALL') then
        begin
          loadSelectorResult(ccrICD9Selector, group, ['ID','*']);
          if ccrICD9Selector.ResultList.Items.Count > 0 then
            rbICD9Selected.Checked := True;
        end;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 059 - CPT '}
///////////////////////////// Parameters Panel #059 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.ccrCPTSelectorSplitterMoved(
  Sender: TObject);
begin
  with cmbbCPTSearch do
    cseCPTSearch.SetBounds(Width, Top,
      ccrCPTSelector.SourceList.Width - Width, Height);
end;

procedure TFrameReportParameters.cseCPTSearchSearchStart(
  aSender: TObject; var aCommand: TCCRSearchCommand);
var
  flags: String;
begin
  if cmbbCPTSearch.ItemIndex = 1 then
    flags := 'D'
  else
    flags := '';
  with cseCPTSearch do
    SetParams(['',Text,flags,'20','']);
end;

procedure TFrameReportParameters.pnlParams059GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, n: Integer;
  group, node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      group := GetNode('/PARAMS/CPTLST');
      if rbCPTAll.Checked then
        begin
          SetAttrVal(group, 'ALL', True);
          DeleteChildren(group);
        end
      else
        with ccrCPTSelector do
          begin
            SetAttrVal(group, 'ALL', False);
            if ResultChanged or FullUpdate then
              begin
                DeleteChildren(group);
                n := ResultList.Items.Count - 1;
                for i:=0 to n do
                  with ResultList.Items[i] do
                    begin
                      node := AppendNode(group, 'CPT', AsString[2]);
                      SetAttrVal(node, 'ID',  AsString[1]);
                    end;
                ResultChanged := False;
              end;
            if ResultList.Items.Count < 1 then
              begin
                aMsgLst.Add(RSC00220);
                aField := cseCPTSearch;
              end;
          end;
    end;
end;

procedure TFrameReportParameters.pnlParams059SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  group: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      rbCPTAll.Checked := True; // This also clears the selector
      group := FindNode('/PARAMS/CPTLST');
      if Assigned(group) and not GetAttrBool(group, 'ALL') then
        begin
          loadSelectorResult(ccrCPTSelector, group, ['','ID','*']);
          if ccrCPTSelector.ResultList.Items.Count > 0 then
            rbCPTSelected.Checked := True;
        end;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 060 - Patients (Seen / Not seen) '}
///////////////////////////// Parameters Panel #060 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams060GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodePatients, 'NOTSEEN',  cbNotSeen.Checked);
      SetAttrVal(NodePatients, 'SEEN',     cbSeen.Checked);
    end;
  if not (cbSeen.Checked or cbNotSeen.Checked) then
    begin
      aMsgLst.Add(RSC00217);
      aField := cbSeen;
    end;
end;

procedure TFrameReportParameters.pnlParams060SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      cbNotSeen.Checked  := GetAttrBool(NodePatients, 'NOTSEEN');
      cbSeen.Checked     := GetAttrBool(NodePatients, 'SEEN');
    end;
end;
{$ENDREGION}

{$REGION ' Panel 062 - Report Type (Complete / Summary) '}
///////////////////////////// Parameters Panel #062 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams062GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodeOptions, 'COMPLETE', rbComplete.Checked);
      SetAttrVal(NodeOptions, 'SUMMARY',  rbSummary.Checked);
    end;
  if not (rbComplete.Checked or rbSummary.Checked) then
    begin
      aMsgLst.Add(RSC00221);
      aField := rbComplete;
    end;
end;

procedure TFrameReportParameters.pnlParams062SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      rbComplete.Checked := GetAttrBool(NodeOptions, 'COMPLETE');
      rbSummary.Checked  := GetAttrBool(NodeOptions, 'SUMMARY');
    end;
end;
{$ENDREGION}

{$REGION ' Panel 064 - Patients (Meds / Labs) '}
///////////////////////////// Parameters Panel #064 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.cbgLabChange(Sender: TObject);
begin
  if StrToIntDef(cbgLab.Code, 0) <> 0 then
    begin
      pnlParams011.Enabled := True;
      pnlParams052.Enabled := True;
      pnlParams053.Enabled := True;
    end
  else
    begin
      pnlParams011.Enabled := False;
      pnlParams052.Enabled := False;
      pnlParams053.Enabled := False;
    end;
end;

procedure TFrameReportParameters.cbgPharmacyChange(Sender: TObject);
begin
  if StrToIntDef(cbgPharmacy.Code, 0) <> 0 then
    begin
      pnlParams010.Enabled := True;
      pnlParams044.Enabled := True;
      pnlParams054.Enabled := True;
    end
  else
    begin
      pnlParams010.Enabled := False;
      pnlParams044.Enabled := False;
      pnlParams054.Enabled := False;
    end;
end;

procedure TFrameReportParameters.pnlParams064GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  icLab, icPharm: Integer;
begin
  with NodePatients do
    begin
      removeAttribute('LAB');
      removeAttribute('NOLAB');
      removeAttribute('NOPHARM');
      removeAttribute('PHARM');
    end;

  icLab   := StrToIntDef(cbgLab.Code, 0);
  icPharm := StrToIntDef(cbgPharmacy.Code, 0);

  with TReportParameters(aList) do
    begin
      if icLab > 0 then
        SetAttrVal(NodePatients, 'LAB', '1')
      else if icLab < 0 then
        SetAttrVal(NodePatients, 'NOLAB', '1');
      if icPharm > 0 then
        SetAttrVal(NodePatients, 'PHARM', '1')
      else if icPharm < 0 then
        SetAttrVal(NodePatients, 'NOPHARM', '1');
    end;
  if (icLab = 0) and (icPharm = 0) then
    begin
      aMsgLst.Add(RSC00213);
      aField := cbgPharmacy.CheckBoxes[0].Control;
    end;
end;

procedure TFrameReportParameters.pnlParams064SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      if GetAttrBool(NodePatients, 'LAB') then
        cbgLab.Code := '1'
      else if GetAttrBool(NodePatients, 'NOLAB') then
        cbgLab.Code := '-1'
      else
        cbgLab.Code := '0';
      if GetAttrBool(NodePatients, 'PHARM') then
        cbgPharmacy.Code := '1'
      else if GetAttrBool(NodePatients, 'NOPHARM') then
        cbgPharmacy.Code := '-1'
      else
        cbgPharmacy.Code := '0';
    end;
end;
{$ENDREGION}

{$REGION ' Panel 065 - Patients (Procedures) '}
///////////////////////////// Parameters Panel #065 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams065GetValues(
  const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with NodePatients do
    begin
      removeAttribute('PROC');
      removeAttribute('NOPROC');
    end;

  with TReportParameters(aList) do
    if rbRcvdProcedures.Checked then
      SetAttrVal(NodePatients, 'PROC', '1')
    else
      SetAttrVal(NodePatients, 'NOPROC', '1');
end;

procedure TFrameReportParameters.pnlParams065SetValues(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    if GetAttrBool(NodePatients, 'NOPROC') then
      rbDidNotRcvdProcedures.Checked := True
    else
      rbRcvdProcedures.Checked := True;
end;
{$ENDREGION}

{$REGION ' Panel 066 - Patients (Received Care) '}
///////////////////////////// Parameters Panel #066 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.cbCareOnlyClick(Sender: TObject);
begin
  pnlParams012.Enabled := cbCareOnly.Checked;
  if not cbCareOnly.Checked then
    rbDivisionsAll.Checked := true;
  pnlParams034.Enabled := cbCareOnly.Checked;
  if (fCurrentReport <> '4') then
  begin
    if (not cbCareOnly.Checked) then
      rbClinicsAll.Checked := true;
    pnlParams050.Enabled := cbCareOnly.Checked;
  end;
end;

procedure TFrameReportParameters.pnlParams066GetValues(
  const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    SetAttrVal(NodePatients, 'CAREONLY', cbCareOnly.Checked);
end;

procedure TFrameReportParameters.pnlParams066Setup(const aReportCode: string);
begin
  if (aReportCode = '4') then               //-- Clinic Follow Up
    pnlParams066.HelpContext := 523
  else if (aReportCode = '12') then         //-- Combined Meds and Labs
    pnlParams066.HelpContext := 524
  else if (aReportCode = '15') then         //-- Procedures
    pnlParams066.HelpContext := 545;
end;

procedure TFrameReportParameters.pnlParams066SetValues(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    cbCareOnly.Checked := GetAttrBool(NodePatients, 'CAREONLY');
  pnlParams012.Enabled := cbCareOnly.Checked;
  pnlParams034.Enabled := cbCareOnly.Checked;
  if aReportCode <> '4' then
    pnlParams050.Enabled := cbCareOnly.Checked;
end;
{$ENDREGION}

{$REGION ' Panel 070 - Other Registeries '}
///////////////////////////// Parameters Panel #070 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.agRegistriesCellChanging(Sender: TObject;
  OldRow, OldCol, NewRow, NewCol: Integer; var Allow: Boolean);
begin
  Allow := (NewRow < agRegistries.FixedRows) or (NewCol = 0);
end;

procedure TFrameReportParameters.agRegistriesEnter(Sender: TObject);
var i, rri: integer;
  frm: TFormOtherRegistries;
  aList: TStringList;
  tmpStr, tmpStr2: String;
begin
  if CCRScreenReaderActive then
  begin
    try
      //Build a list of strings from the data in the grid
      aList := TStringList.Create;
      for i := agRegistries.FixedRows to agRegistries.RowCount-1 do
      begin
        rri := agRegistries.RealRowIndex(i);
        tmpStr2 := Trim(agRegistries.GridCells[orMode,rri]);
        if length(tmpStr2) = 0 then
          tmpStr2 := 'Ignore';
        tmpStr := tmpStr2 + U + agRegistries.AllCells[orDescr, i] + U
                + agRegistries.AllCells[orIEN, i];
        aList.Add(tmpStr);
      end;

      frm := TFormOtherRegistries.Create(aList);

      //Put the data entered on the 508 form back into the grid
      if frm.Edit = mrOk then
      begin
        aList := frm.ListData;
        for i := 0 to aList.Count - 1 do
        begin
          tmpStr  := trim(piece(aList[i], U, 1));
          if tmpStr = 'Ignore' then
            tmpStr := ' ';
          agRegistries.AllCells[orMode, agRegistries.FixedRows+i] := tmpStr;
        end;
      end;
    finally
      aList.Clear;
      aList.Free;
      frm.Free;
    end;
    SendMessage((Self.Owner as TWinControl).Handle, WM_NEXTDLGCTL, 0, 0 );
  end;
end;

procedure TFrameReportParameters.pnlParams070GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, rri: Integer;
  group, node: TDomNode;
  modeVal: String;
begin
  with TReportParameters(aList) do
    begin
      group := GetNode('/PARAMS/OTHER_REGISTRIES');
      DeleteChildren(group);
      for i:=agRegistries.RowCount-1 downto agRegistries.FixedRows do
        begin
          rri := agRegistries.RealRowIndex(i);
          modeVal := Trim(agRegistries.GridCells[orMode,rri]);
          if modeVal <> '' then
            begin
              node := AppendNode(group, 'REGISTRY', agRegistries.GridCells[orDescr,rri]);
              SetAttrVal(node, 'ID', agRegistries.GridCells[orIEN,rri]);
              if modeVal = 'Include' then
                SetAttrVal(node, 'MODE', '1')
              else
                SetAttrVal(node, 'MODE', '-1');
              SetAttrVal(node, 'NAME', agRegistries.GridCells[orName,rri]);
            end;
        end;
    end;
end;

procedure TFrameReportParameters.pnlParams070SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  i, rri: Integer;
  group, node: TDomNode;
  query, tmpMode: String;
begin
  if agRegistries.RowCount > agRegistries.FixedRows then
    with TReportParameters(aList) do
      begin
        group := FindNode('/PARAMS/OTHER_REGISTRIES');
        if Assigned(group) then
          for i:=agRegistries.RowCount-1 downto agRegistries.FixedRows do
            begin
              rri := agRegistries.RealRowIndex(i);
              query := 'REGISTRY[@ID=' + agRegistries.GridCells[orIEN,rri] + ']';
              node := group.FindNode(query);
              tmpMode := ' ';
              if Assigned(node) then
              begin
                case TReportParameters(aList).GetAttrInt(node, 'MODE') of
                  -1:  tmpMode := 'Exclude';
                   1:  tmpMode := 'Include';
                  else tmpMode := ' ';
                end;
                agRegistries.GridCells[orMode,rri] := tmpMode;
              end;
            end
        else
          for i:=agRegistries.RowCount-1 downto agRegistries.FixedRows do
            begin
              rri := agRegistries.RealRowIndex(i);
              agRegistries.GridCells[orMode,rri] := ' ';
            end;
      end
  else
    begin
      pnlParams070.Align   := alBottom;
      pnlParams070.Visible := False;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 090 - Treatment History '}
///////////////////////////// Parameters Panel #090 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.cbExperiencedClick(Sender: TObject);
begin
  edtTreatmentDays.Enabled := cbExperienced.Checked;
  edtTreatmentDays.Color := CtrlColor(edtTreatmentDays.Enabled);
  //-- Section 508: Special processing for screen readers
  stxtTreatmentExclude.TabStop := cbExperienced.Checked and
                                  stxtTreatmentWarning.TabStop;
end;

procedure TFrameReportParameters.edtTreatmentDaysKeyPress(Sender: TObject;
  var Key: Char);
begin
  if (not (Key in ['0'..'9',#8])) then
    Key := #0;
end;

procedure TFrameReportParameters.pnlParams090GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
var
  group, node: TDomNode;
  num: integer;
begin
  if (not cbNaive.Checked) and (not cbExperienced.Checked) then
  begin
    aMsgLst.Add(RSC00206);
    aField := cbNaive;
  end
  else if (cbExperienced.Checked) and (edtTreatmentDays.Text = '') then
  begin
    aMsgLst.Add(RSC00274);
    aField := edtTreatmentDays;
  end
  else begin
    with TReportParameters(aList) do
    begin
      SetAttrVal(NodePatients, 'CAREONLY', true);

      DeleteNode('/PARAMS/TREATMENT_HISTORY');
      group := GetNode('/PARAMS');
      node := AppendNode(group, 'TREATMENT_HISTORY');
      SetAttrVal(node, 'NAIVE', cbNaive.Checked);
      SetAttrVal(node, 'EXP', cbExperienced.Checked);
      if cbExperienced.Checked then
      begin
        num := StrToIntDef(edtTreatmentDays.Text, 0);
        if (num > 0) then
          SetAttrVal(node, 'EXP_DAYS', IntToStr(num))
        else begin
          aMsgLst.Add(Format(RSC00276, ['days', 1, 9999]));
          aField := edtTreatmentDays;
        end;
      end;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams090Setup(const aReportCode: string);
begin
  //-- Section 508: Special processing for screen readers
  stxtTreatmentWarning.TabStop  := CCRScreenReaderActive;
  stxtTreatmentWarning1.TabStop := stxtTreatmentWarning.TabStop;
end;

procedure TFrameReportParameters.pnlParams090SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
var
  node: TDomNode;
begin
  with TReportParameters(aList) do
  begin
    node := FindNode('/PARAMS/TREATMENT_HISTORY');
    if Assigned(node) then
    begin
      if GetAttrBool(node, 'NAIVE') then
        cbNaive.Checked := True;
      if GetAttrBool(node, 'EXP') then
        cbExperienced.Checked := True;
      if cbExperienced.Checked then
        edtTreatmentDays.Text := GetAttrStr(node, 'EXP_DAYS');
    end;
  end;
end;
{$ENDREGION}

{$REGION ' Panel 091 - Weeks After DAA Start '}
///////////////////////////// Parameters Panel #091 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.edtWeeksAfterDAAKeyPress(Sender: TObject;
  var Key: Char);
begin
  if (not (Key in ['0'..'9',#8])) then
    Key := #0;
end;

procedure TFrameReportParameters.pnlParams091GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
var
  node: TDomNode;
  num: integer;
begin
  with TReportParameters(aList) do
  begin
    DeleteNode('/PARAMS/WEEKS_AFTER');
    SetNodeVal('/PARAMS/WEEKS_AFTER', edtWeeksAfterDAA.Text);
    num := StrToIntDef(edtWeeksAfterDAA.Text, 0);
    node := GetNode('/PARAMS/WEEKS_AFTER');
    SetAttrVal(node, 'MOST_RECENT', cbPriorDAAStart.Checked);
    if edtWeeksAfterDAA.Text = '' then
    begin
      aMsgLst.Add(RSC00275);
      aField := edtWeeksAfterDAA;
    end
    else if (num = 0) then
    begin
      aMsgLst.Add(Format(RSC00276, ['weeks', 1, 999]));
      aField := edtWeeksAfterDAA;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams091Setup(const aReportCode: string);
begin
  stxtWeeksAfterDAA.TabStop := CCRScreenReaderActive;
end;

procedure TFrameReportParameters.pnlParams091SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
var
  node: TDomNode;
begin
  with TReportParameters(aList) do
  begin
    node := GetNode('/PARAMS/WEEKS_AFTER');
    edtWeeksAfterDAA.Text := GetNodeVal('/PARAMS/WEEKS_AFTER');
    cbPriorDAAStart.Checked := GetAttrBool(node, 'MOST_RECENT');
  end;
end;
{$ENDREGION}

{$REGION ' Panel 100 - Local Fields '}
///////////////////////////// Parameters Panel #100 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.agLocalFieldsCellChanging(Sender: TObject;
  OldRow, OldCol, NewRow, NewCol: Integer; var Allow: Boolean);
begin
  Allow := (NewRow < agLocalFields.FixedRows) or (NewCol = 0);
end;

procedure TFrameReportParameters.agLocalFieldsEnter(Sender: TObject);
var i, rri: integer;
  frm: TFormLocalFields;
  aList: TStringList;
  tmpStr, tmpStr2: String;
begin
  if CCRScreenReaderActive then
  begin
    try
      //Build a list of strings from the data in the grid
      aList := TStringList.Create;
      for i := agLocalFields.FixedRows to agLocalFields.RowCount-1 do
      begin
        rri := agLocalFields.RealRowIndex(i);
        tmpStr2 := Trim(agLocalFields.GridCells[lfMode,rri]);
        if length(tmpStr2) = 0 then
          tmpStr2 := 'Ignore';
        tmpStr := tmpStr2 + U + agLocalFields.AllCells[lfDescr, i] + U
                + agLocalFields.AllCells[lfName, i] + U
                + agLocalFields.AllCells[lfIEN, i];
        aList.Add(tmpStr);
      end;

      frm := TFormLocalFields.Create(aList);

      //Put the data entered on the 508 form back into the grid
      if frm.Edit = mrOk then
      begin
        aList := frm.ListData;
        for i := 0 to aList.Count - 1 do
        begin
          tmpStr  := trim(piece(aList[i], U, 1));
          if tmpStr = 'Ignore' then
            tmpStr := ' ';
          agLocalFields.AllCells[lfMode, agLocalFields.FixedRows+i] := tmpStr;
        end;
      end;
    finally
      aList.Clear;
      aList.Free;
      frm.Free;
    end;
    SendMessage((Self.Owner as TWinControl).Handle, WM_NEXTDLGCTL, 0, 0 );
  end;
end;

procedure TFrameReportParameters.pnlParams100GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, rri: Integer;
  base, group, node: TDomNode;
  modeVal: String;
begin
  with TReportParameters(aList) do
  begin
    DeleteNode('/PARAMS/HIV_DX');
    group := GetNode('/PARAMS/LOCAL_FIELDS');
    DeleteChildren(group);
    for i := agLocalFields.RowCount-1 downto agLocalFields.FixedRows do
    begin
      rri := agLocalFields.RealRowIndex(i);
      modeVal := Trim(agLocalFields.GridCells[lfMode,rri]);
      if modeVal <> '' then
      begin
        if agLocalFields.GridCells[lfIEN,rri] <> '-999' then
        begin
          node := AppendNode(group, 'FIELD', agLocalFields.GridCells[lfDescr,rri]);
          SetAttrVal(node, 'ID', agLocalFields.GridCells[lfIEN,rri]);
          if modeVal = 'Include' then
            SetAttrVal(node, 'MODE', '1')
          else
            SetAttrVal(node, 'MODE', '-1');
          SetAttrVal(node, 'NAME', agLocalFields.GridCells[lfName,rri]);
        end
        //-- Special processing for HIV registry pseudo local field
        else begin
          base := GetNode('/PARAMS');
          if modeVal = 'Include' then
            modeVal := '1'
          else
            modeVal := '-1';
          node := AppendNode(base, 'HIV_DX', modeVal);
        end;
      end;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams100SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  i, rri: Integer;
  base, group, node: TDomNode;
  query, tmpMode: String;
begin
  if agLocalFields.RowCount > agLocalFields.FixedRows then
    with TReportParameters(aList) do
      begin
        base := FindNode('/PARAMS/HIV_DX');
        group := FindNode('/PARAMS/LOCAL_FIELDS');
        if Assigned(group) or Assigned(base) then
          for i := agLocalFields.RowCount-1 downto agLocalFields.FixedRows do
          begin
            rri := agLocalFields.RealRowIndex(i);
            //-- Special processing for HIV registry pseduo local field
            if agLocalFields.GridCells[lfIEN,rri] = '-999' then
            begin
              tmpMode := GetNodeVal('/PARAMS/HIV_DX');
              if tmpMode = '1' then
                tmpMode := 'Include'
              else if tmpMode = '-1' then
                tmpMode := 'Exclude'
              else
                tmpMode := ' ';
              agLocalFields.GridCells[lfMode,rri] := tmpMode;
            end
            else begin
              query := 'FIELD[@ID=' + agLocalFields.GridCells[lfIEN,rri] + ']';
              node := group.FindNode(query);
              tmpMode := ' ';
              if Assigned(node) then
              begin
                case TReportParameters(aList).GetAttrInt(node, 'MODE') of
                  -1:  tmpMode := 'Exclude';
                   1:  tmpMode := 'Include';
                  else tmpMode := ' ';
                end;
                agLocalFields.GridCells[lfMode,rri] := tmpMode;
              end;
            end;
          end
        else
          for i:=agLocalFields.RowCount-1 downto agLocalFields.FixedRows do
          begin
            rri := agLocalFields.RealRowIndex(i);
            agLocalFields.GridCells[lfMode,rri] := ' ';
          end;
      end
  else
    begin
      pnlParams100.Align   := alBottom;
      pnlParams100.Visible := False;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 120 - Highest Utilization '}
///////////////////////////// Parameters Panel #120 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams120GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    if rbDetailsBoth.Checked then
      begin
        SetNodeVal('/PARAMS/MAXUTNUM', edHighestUtilNum120.Text);
        SetNodeVal('/PARAMS/MINRPNUM', edMinRPNum120.Text);
        if (edHighestUtilNum120.Text = '') and (edMinRPNum120.Text = '') then
          begin
            aMsgLst.Add(RSC00218);
            aField := edHighestUtilNum120;
          end;
      end
    else
      begin
        DeleteNode('/PARAMS/MAXUTNUM');
        DeleteNode('/PARAMS/MINRPNUM');
      end;
end;

procedure TFrameReportParameters.pnlParams120Setup(const aReportCode: string);
begin
  //-- Section 508: Move edits behind static text fields for JAWS.
  if CCRScreenReaderActive then
  begin
    edHighestUtilNum120.Left := stxtNumUsers120.Left + stxtNumUsers120.Width + 2;
    edMinRPNum120.Left := stxtNumProcs120.Left + stxtNumProcs120.Width + 2;
  end;
end;

procedure TFrameReportParameters.pnlParams120SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      edHighestUtilNum120.Text := GetNodeVal('/PARAMS/MAXUTNUM');
      edMinRPNum120.Text       := GetNodeVal('/PARAMS/MINRPNUM');
      if (edHighestUtilNum120.Text <> '') or (edMinRPNum120.Text <> '') then
        rbDetailsBoth.Checked := True
      else
        rbSummaryBoth.Checked := True;
    end;
end;

procedure TFrameReportParameters.rbDetailsBothClick(Sender: TObject);
begin
  edHighestUtilNum120.Enabled := True;
  edMinRPNum120.Enabled       := True;
end;

procedure TFrameReportParameters.rbSummaryBothClick(Sender: TObject);
begin
  with edHighestUtilNum120 do
    begin
      Enabled := False;
      Text    := '';
    end;
  with edMinRPNum120 do
    begin
      Enabled := False;
      Text    := '';
    end;
end;
{$ENDREGION}

{$REGION ' Panel 130 - Selection Rules '}
///////////////////////////// Parameters Panel #130 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams130GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i: Integer;
  group, node: TDomNode;
  ci: TCCRGridItem;
begin
  with TReportParameters(aList) do
    begin
      group := GetNode('/PARAMS/SELRULES');
      DeleteChildren(group);
      for i:=cgvSelectionRules.Items.Count-1 downto 0 do
        begin
          ci := cgvSelectionRules.Items[i];
          if ci.Checked then
            begin
              node := AppendNode(group, 'RULE', ci.AsString[iDescr]);
              SetAttrVal(node, 'ID', ci.AsString[iIEN]);
              SetAttrVal(node, 'NAME', ci.AsString[iName]);
            end;
        end;
    end;
end;

procedure TFrameReportParameters.pnlParams130SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
var
  i: Integer;
  group: TDomNode;
  query: String;
begin
  if cgvSelectionRules.Items.Count > 0 then
    with TReportParameters(aList) do
      begin
        group := FindNode('/PARAMS/SELRULES');
        if Assigned(group) then
          for i:=cgvSelectionRules.Items.Count-1 downto 0 do
            begin
              query := 'RULE[@ID=' + cgvSelectionRules.Items[i].AsString[iIEN] + ']';
              cgvSelectionRules.Items[i].Checked := Assigned(group.FindNode(query));
            end
        else
          for i:=cgvSelectionRules.Items.Count-1 downto 0 do
            cgvSelectionRules.Items[i].Checked := False;
      end
  else
    begin
      pnlParams130.Align   := alBottom;
      pnlParams130.Visible := False;
    end;
end;
{$ENDREGION}

{$REGION ' Panel 140 - Select Patient '}
///////////////////////////// Parameters Panel #140 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.ccrPatientSelectorSplitterMoved(
  Sender: TObject);
begin
  csePatientSearch.SetBounds(41, 0, ccrPatientSelector.SourceList.Width-41,
    pnlPatientSearch140.ClientHeight);
end;

procedure TFrameReportParameters.csePatientSearchSearchStart(
  aSender: TObject; var aCommand: TCCRSearchCommand);
begin
  with csePatientSearch do
    begin
      SetParams([RegInfo.IEN,'0',csePatientSearch.Text,'D','20','']);
      SearchMaxCount := CCROptions.MaxPatientCount;
    end;
end;

procedure TFrameReportParameters.pnlParams140GetValues(const aReportCode: String;
  aList: TCustomReportParameters; aMsgLst: TStrings; var aField: TWinControl);
var
  i, n: Integer;
  node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
      if rbPatientsAll.Checked then
        begin
          SetAttrVal(NodePatients, 'ALL', True);
          DeleteChildren(NodePatients);
        end
      else
        with ccrPatientSelector do
          begin
            SetAttrVal(NodePatients, 'ALL', False);
            if ResultChanged or FullUpdate then
              begin
                DeleteChildren(NodePatients);
                n := ResultList.Items.Count - 1;
                for i:=0 to n do
                  with ResultList.Items[i] do
                    begin
                      node := AppendNode(NodePatients, 'PT', AsString[1]);
                      SetAttrVal(node, 'ID', AsString[4]);
                      SetAttrVal(node, 'SSN', AsString[2]);
                    end;
                ResultChanged := False;
              end;
            if ResultList.Items.Count < 1 then
              begin
                aMsgLst.Add(RSC00219);
                aField := csePatientSearch;
              end;
          end;
    end
end;

procedure TFrameReportParameters.pnlParams140Setup(const aReportCode: string);
begin
  //-- Section 508: Set the Name columns in the lists for JAWS
  if CCRScreenReaderActive then
  begin
    if pos('Available', ccrPatientSelector.SourceList.Fields[idscName].Caption) = 0 then
    begin
      ccrPatientSelector.SourceList.Fields[idscName].Caption := 'Available ' +
        ccrPatientSelector.SourceList.Fields[idscName].Caption;
      ccrPatientSelector.ResultList.Fields[idscName].Caption := 'Selected ' +
        ccrPatientSelector.ResultList.Fields[idscName].Caption;
    end;
  end;

end;

procedure TFrameReportParameters.pnlParams140SetValues(const aReportCode: String;
  aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      rbpatientsAll.Checked := True; // This also clears the selector
      if not GetAttrBool(NodePatients, 'ALL') then
        begin
          loadSelectorResult(ccrPatientSelector, NodePatients, ['','*','SSN','ID','ID']);
          if ccrPatientSelector.ResultList.Items.Count > 0 then
            rbPatientsSelected.Checked := True;
        end;
    end;
end;

procedure TFrameReportParameters.rbPatientsAllClick(Sender: TObject);
var i: integer;
begin
  rbAllClick(rbPatientsAll);
  pnlParams070.Enabled := True;
  pnlParams100.Enabled := True;
  agRegistries.Color := CtrlColor(true);
  for i := agRegistries.FixedRows to agRegistries.RowCount - 1 do
    agRegistries.RowColor[i] := CtrlColor(true);
  agLocalFields.Color := CtrlColor(true);
  for i := agLocalFields.FixedRows to agLocalFields.RowCount - 1 do
    agLocalFields.RowColor[i] := CtrlColor(true);
end;

procedure TFrameReportParameters.rbPatientsSelectedClick(Sender: TObject);
var i: integer;
begin
  rbSelectedClick(rbPatientsSelected);
  if (fCurrentReport <> '4') then
    rbClinicsAll.Checked := true;
  rbDivisionsAll.Checked := true;
  pnlParams070.Enabled := false;
  pnlParams100.Enabled := false;
  agRegistries.Color := CtrlColor(false);
  for i := agRegistries.FixedRows to agRegistries.RowCount - 1 do
    agRegistries.RowColor[i] := CtrlColor(false);
  agLocalFields.Color := CtrlColor(false);
  for i := agLocalFields.FixedRows to agLocalFields.RowCount - 1 do
    agLocalFields.RowColor[i] := CtrlColor(false);
end;
{$ENDREGION}

{$REGION ' Panel 150 - Procedures '}
///////////////////////////// Parameters Panel #150 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.cbInpatient150Click(Sender: TObject);
begin
  pnlParams160.Enabled := cbInpatient150.Checked;
end;

procedure TFrameReportParameters.cbOutpatient150Click(Sender: TObject);
begin
  pnlParams059.Enabled := cbOutpatient150.Checked;
end;

procedure TFrameReportParameters.pnlParams150GetValues(
  const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);
begin
  with TReportParameters(aList) do
    begin
      SetAttrVal(NodePatients, 'INPATIENT',  cbInpatient150.Checked);
      SetAttrVal(NodePatients, 'OUTPATIENT', cbOutpatient150.Checked);
    end;
  if not (cbInpatient150.Checked or cbOutpatient150.Checked) then
    begin
      aMsgLst.Add(RSC00206);
      aField := cbInpatient150;
    end;
end;

procedure TFrameReportParameters.pnlParams150SetValues(
  const aReportCode: String; aList: TCustomReportParameters);
begin
  with TReportParameters(aList) do
    begin
      cbInpatient150.Checked  := GetAttrBool(NodePatients, 'INPATIENT');
      cbOutpatient150.Checked := GetAttrBool(NodePatients, 'OUTPATIENT');
    end;
  pnlParams160.Enabled := cbInpatient150.Checked;
  pnlParams059.Enabled := cbOutpatient150.Checked;
end;
{$ENDREGION}

{$REGION ' Panel 160 - ICD-9 '}
///////////////////////////// Parameters Panel #160 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.acICD9GroupAddExecute(Sender: TObject);
var
  gn: PVirtualNode;
begin
  with ccrICD9Selector160.ResultTree do
    begin
      if edICD9GroupName.Text = '' then
        MessageDlg508('', RSC00224, mtWarning, [mbOK], 0)
      else if FindGroup(edICD9GroupName.Text) = nil then
        begin
          gn := AddGroup(edICD9GroupName.Text);
          if Assigned(gn) then
            begin
              FocusedNode := gn;
              ClearSelection;
              Selected[gn] := True;
            end;
        end
      else
        MessageDlg508('', Format(RSC00222,[edICD9GroupName.Text]), mtWarning, [mbOK], 0);
    end;
end;

procedure TFrameReportParameters.acICD9GroupDeleteExecute(Sender: TObject);
begin
  deleteResultTreeGroup(ccrICD9Selector160.ResultTree);
end;

procedure TFrameReportParameters.ccrICD9Selector160ResultListKeyAction(
  Sender: TBaseVirtualTree; var CharCode: Word; var Shift: TShiftState;
  var DoDefault: Boolean);
begin
  if (Shift = []) and (CharCode = VK_DELETE) then
    begin
      deleteResultTreeGroup(ccrICD9Selector160.ResultTree);
      DoDefault := False;
    end;
end;

procedure TFrameReportParameters.cseICD9Search160SearchStart(
  aSender: TObject; var aCommand: TCCRSearchCommand);
var
  flags: String;
  sSystem: String; // ICD-10 Remediation. ROR*1.5*19 2012-03-06
begin
  if cmbxICD9Search160.ItemIndex = 1 then
    flags := 'D'
  else
    flags := '';
  if ccrICD9Selector160.ProcMode then
    flags := flags + 'O';
  with cseICD9Search160 do
    begin
// ICD-10 Remediation. ROR*1.5*19 2012-01-06 ================================[
      if cmbxSystem160.Text = 'ICD-9' then
        sSystem := 'ICD9'
      else
        sSystem := 'ICD10';
      SearchRPCName := 'ROR LIST ICD';  // 'ROR LIST ICD-9';
      //SetParams(['',Text,flags,'20','']);
      SetParams(['',Text,flags,'20','',sSystem]);
// ICD-10 Remediation. ROR*1.5*19 2012-01-06 ================================]
    end;
end;

procedure TFrameReportParameters.edICD9GroupNameKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (Shift = []) and (Key = VK_RETURN) then
    acICD9GroupAdd.Execute;
end;

procedure TFrameReportParameters.pnlParams160ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
var
  node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
//      node := FindNode('/PARAMS/ICD9LST');// ICD-10 Remediation. ROR*1.5*19 2012-01-10. 
      node := FindNode(nxml_PARAMS_ICDLST); // ICD-10 Remediation. ROR*1.5*19 2012-01-10
      if Assigned(node) then
        DeleteChildren(node);
    end;
end;

procedure TFrameReportParameters.pnlParams160GetValues(
  const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);

  function group(srcGroup: PVirtualNode; dstNode: TDomNode): TDomNode;
  var
    srcItem: PVirtualNode;
    empty: Boolean;
    params: TReportParameters;
    dstItem: TDomNode;
    itemName: String;
  begin
    params := TReportParameters(aList);
    with ccrICD9Selector160.ResultTree do
      begin
        empty := True;
        Result := params.AppendNode(dstNode, 'GROUP');
        params.SetAttrVal(Result, 'ID', AsString[srcGroup,idscName]);

        srcItem := GetFirstChild(srcGroup);
        while Assigned(srcItem) do
          begin
            itemName := AsString[srcItem,idscName];
//            dstItem := params.AppendNode(Result, 'ICD9', itemName);   // ICD-10 Remediation. ROR*1.5*19 2012-01-10
            dstItem := params.AppendNode(Result, nxmlICDNode, itemName);// ICD-10 Remediation. ROR*1.5*19 2012-01-10
            params.SetAttrVal(dstItem, 'ID', AsString[srcItem,idscCode]);
            params.SetAttrVal(dstItem, 'VERSION', AsString[srcItem,idscVersion]);// ICD-10 Remediation. ROR*1.5*19 2012-01-10
            empty := False;
            srcItem := GetNextSibling(srcItem);
          end;

        if empty then
          begin
            params.DeleteNode(Result);
            Result := nil;
          end;
      end;
  end;

var
  srcGroup: PVirtualNode;
  empty: Boolean;
  params: TReportParameters;
  node: TDomNode;
begin
  params := TReportParameters(aList);
// ICD-10 Remediation. ROR*1.5*19 2012-01-10 ================================[
// removing ICD9LST nodes from the template
  node := params.FindNode('/PARAMS/ICD9LST'); // searching for old values
  if Assigned(node) then
    node.NodeName := nxml_ICDLST
  else
    node := params.GetNode(nxml_PARAMS_ICDLST);
// ICD-10 Remediation. ROR*1.5*19 2012-01-10 ================================]
  with ccrICD9Selector160 do
    begin
      params.SetAttrVal(node, 'PROCMODE', ProcMode);
      if rbAll160.Checked then
        begin
          params.SetAttrVal(node, 'ALL', True);
          params.DeleteChildren(node);
        end
      else
        begin
          empty := True;
          params.SetAttrVal(node, 'ALL', False);
          if ResultChanged or FullUpdate then
            begin
              params.DeleteChildren(node);
              srcGroup := ResultTree.GetFirstChild(nil);
              while Assigned(srcGroup) do
                begin
                  if group(srcGroup, node) <> nil then
                    empty := False;
                  srcGroup := ResultTree.GetNextSibling(srcGroup);
                end;
              ResultChanged := False;
            end;
          if empty then
            begin
              aMsgLst.Add(RSC00216);
              aField := cseICD9Search160;
            end;
        end;
    end;
end;

procedure TFrameReportParameters.pnlParams160Setup(
  const aReportCode: String);
begin
  with ccrICD9Selector160 do
    begin
      ProcMode := (aReportCode = '15');
      Clear;
    end;
  stxtSearch160.Left := cseICD9Search160.Left;
  pnlICDGroupAlign160.Width := ccrICD9Selector160.ResultTree.Width;
  pnlICDGroupAlign160.Left := ccrICD9Selector160.ResultTree.Left;
  pnlICD9Group160.Width := pnlICDGroupAlign160.Width;
  //-- Section 508: Set the first column ("Dummy508" ) width to 1 and change
  //   the name columns.
  ccrICD9Selector160.ResultTree.Header.Columns[0].Width := 1;
  if not CCRScreenReaderActive then
  begin
    ccrICD9Selector160.SourceList.Fields[idscName].Caption := 'Name';
    ccrICD9Selector160.ResultTree.Header.Columns[idscName].Text := 'Name';
  end;
end;

procedure TFrameReportParameters.pnlParams160SetValues(
  const aReportCode: String; aList: TCustomReportParameters);

  function group(srcGroup: TDomNode): PVirtualNode;
  var
    srcItem: TDomNode;
    dstItem: PVirtualNode;
    params: TReportParameters;
    empty: Boolean;
    aSystem,    // ICD-10 Remediation ROR*1.5*19 2012-01-24
    aName: String;
    dummy: String;
  begin
    params := TReportParameters(aList);
    with ccrICD9Selector160.ResultTree do
      begin
        // Leave the "dummy := params.Text" line in even though it does nothing.
        // When it is removed, an access violation frequently occurs on the line
        // where GetAttrStr is used.
        dummy := params.Text;
        aName := params.GetAttrStr(srcGroup, 'ID');
        if aName <> '' then
          begin
            Result := FindGroup(aName);
            if not Assigned(Result) then
              Result := AddGroup(aName);
          end
        else
          Result := nil;
        if Assigned(Result) then
          begin
            DeleteChildren(Result);
            empty := True;
            srcItem := srcGroup.FirstChild;
            while Assigned(srcItem) do
              begin
                aName := params.GetNodeVal(srcItem);
                if aName <> '' then
                  begin
// ICD-10 Remediation ROR*1.5*19 2012-01-24 =================================[
//                    dstItem := AddItem(Result, aName, params.GetAttrStr(srcItem,'ID'));
                    aSystem := params.GetAttrStr(srcItem,nxml_Version);
                    dstItem := AddItem(Result, aSystem, aName, params.GetAttrStr(srcItem,'ID'));
// ICD-10 Remediation ROR*1.5*19 2012-01-24 =================================]
                    empty := False;
                  end;
                srcItem := srcItem.NextSibling;
              end;
            if empty then
              begin
                DeleteGroup(Result);
                Result := nil;
              end;
          end;
      end;
  end;

var
  srcGroup: TDomNode;
  params: TReportParameters;
  empty: Boolean;
  node: TDomNode;
begin
  params := TReportParameters(aList);

  params.Text := fixNodeNames(params.Text);// ROR*1.5*19 2012-04-12 === fixing existing templates

  with ccrICD9Selector160 do
    begin
      ResultTree.BeginUpdate;
      try
//        node := params.FindNode('/PARAMS/ICD9LST');// ICD-10 Remediation. ROR*1.5*19 2012-01-10
        node := params.FindNode(nxml_PARAMS_ICDLST); // ICD-10 Remediation. ROR*1.5*19 2012-01-10
        if Assigned(node) and not params.GetAttrBool(node, 'ALL') then
          begin
            empty := True;
            srcGroup := node.FirstChild;
            while Assigned(srcGroup) do
              begin
                if group(srcGroup) <> nil then
                  empty := False;
                srcGroup := srcGroup.NextSibling;
              end;
            if not empty then
              rbSelected160.Checked := True
            else
              Clear;
          end
        else
          rbAll160.Checked := True; // This also clears the selector
      finally
        ResultTree.EndUpdate;
      end;
      ResultChanged := False;
    end;
end;

procedure TFrameReportParameters.pnlICD9Group160Resize(Sender: TObject);
begin
  with pnlICD9Group160 do
    begin
      edICD9GroupName.SetBounds(0, 0, ClientWidth - 2*ClientHeight, ClientHeight);
      spbICD9GroupAdd.SetBounds(edICD9GroupName.Width, 0, ClientHeight, ClientHeight);
      spbICD9GroupDelete.SetBounds(edICD9GroupName.Width+ClientHeight, 0,
        ClientHeight, ClientHeight);
    end;
end;

procedure TFrameReportParameters.ccrICD9Selector160SplitterMoved(
  Sender: TObject);
begin
  pnlICD9Search160.DisableAlign;
  try
    with cmbxICD9Search160 do
//  ICD-10 Remediation. ROR*1.5*19 2012-01-06 ===============================[
//      cseICD9Search160.SetBounds(Width, 17, ccrICD9Selector160.SourceList.Width - Width, Height);
      cseICD9Search160.SetBounds(170, 15, ccrICD9Selector160.SourceList.Width - 170, Height);
//  ICD-10 Remediation. ROR*1.5*19 2012-01-06 ===============================]
    pnlICDGroupAlign160.Width := ccrICD9Selector160.ResultTree.Width;
    pnlICDGroupAlign160.Left := ccrICD9Selector160.ResultTree.Left;
    pnlICD9Group160.Width  := pnlICDGroupAlign160.Width;
    stxtSearch160.Left := cseICD9Search160.Left;
  finally
    pnlICD9Search160.EnableAlign;
  end;
end;
{$ENDREGION}

{$REGION ' Panel 180 - Other Diagnoses '}
///////////////////////////// Parameters Panel #180 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams180ClearParams(
  const aReportCode: String; aList: TCustomReportParameters);
var
  node: TDomNode;
begin
  with TReportParameters(aList) do
    begin
//      node := FindNode('/PARAMS/ICD9FILT'); // ICD-10 Remediation. ROR*1.5*19 2012-01-10
      node := FindNode(nxml_PARAMS_ICDFILT);  // ICD-10 Remediation. ROR*1.5*19 2012-01-10
      if Assigned(node) then
        DeleteChildren(node);
    end;
end;

procedure TFrameReportParameters.pnlParams180GetValues(
  const aReportCode: String; aList: TCustomReportParameters;
  aMsgLst: TStrings; var aField: TWinControl);

  function group(srcGroup: PVirtualNode; dstNode: TDomNode): TDomNode;
  var
    srcItem: PVirtualNode;
    empty: Boolean;
    params: TReportParameters;
    dstItem: TDomNode;
    itemName: String;
  begin
    params := TReportParameters(aList);
    with ccrOtherDiagSelector180.ResultTree do
      begin
        empty := True;
        Result := params.AppendNode(dstNode, 'GROUP');
        params.SetAttrVal(Result, 'ID', AsString[srcGroup,idscName]);

        srcItem := GetFirstChild(srcGroup);
        while Assigned(srcItem) do
          begin
            itemName := AsString[srcItem,idscName];
//            dstItem := params.AppendNode(Result, 'ICD9', itemName);   // ICD-10 Remediation. ROR*1.5*19 2012-01-10
            dstItem := params.AppendNode(Result, nxmlICDNode, itemName);// ICD-10 Remediation. ROR*1.5*19 2012-01-10
            params.SetAttrVal(dstItem, 'ID', AsString[srcItem,idscCode]);
            params.SetAttrVal(dstItem, 'VERSION', AsString[srcItem,idscVersion]); // ICD-10 Remediation. ROR*1.5*19 
            empty := False;
            srcItem := GetNextSibling(srcItem);
          end;

        if empty then
          begin
            params.DeleteNode(Result);
            Result := nil;
          end;
      end;
  end;

var
  srcGroup: PVirtualNode;
  empty: Boolean;
  params: TReportParameters;
  node: TDomNode;
begin
  params := TReportParameters(aList);
//  node := params.GetNode('/PARAMS/ICD9FILT');// ICD-10 Remediation. ROR*1.5*19 2012-01-06
  node := params.GetNode(nxml_PARAMS_ICDFILT); // ICD-10 Remediation. ROR*1.5*19 2012-01-06
  with ccrOtherDiagSelector180 do
  begin
    params.SetAttrVal(node, 'PROCMODE', ProcMode);
    params.SetAttrVal(node, 'FILTER', ICD9Filter);
    if rbIgnore180.Checked then
    begin
      params.DeleteChildren(node);
    end
    else begin

      empty := True;
      if ResultChanged or FullUpdate then
      begin
        params.DeleteChildren(node);
        srcGroup := ResultTree.GetFirstChild(nil);
        while Assigned(srcGroup) do
        begin
          if group(srcGroup, node) <> nil then
            empty := False;
          srcGroup := ResultTree.GetNextSibling(srcGroup);
        end;
        ResultChanged := False;
      end;
      if empty then
      begin
        aMsgLst.Add(RSC00225);
        aField := ccrOtherDiagSelector180;
      end;
    end;
  end;
end;

procedure TFrameReportParameters.pnlParams180Setup(
  const aReportCode: String);
begin
  with ccrOtherDiagSelector180 do
  begin
    ProcMode := False;
    Clear;
    CustomAdd := True;
    CustomRemove := True;
  end;
  //-- Section 508: Set the first column ("Dummy508" ) width to 1 and change
  //   the name columns.
  ccrOtherDiagSelector180.ResultTree.Header.Columns[0].Width := 1;
  if CCRScreenReaderActive then
  begin
    ccrOtherDiagSelector180.SourceList.Fields[idscName].Caption := 'Name';
    ccrOtherDiagSelector180.ResultTree.Header.Columns[idscName].Text := 'Name';
  end;
end;

procedure TFrameReportParameters.pnlParams180SetValues(
  const aReportCode: String; aList: TCustomReportParameters);

  function group(srcGroup: TDomNode): PVirtualNode;
  var
    srcItem: TDomNode;
    dstItem: PVirtualNode;
    params: TReportParameters;
    empty: Boolean;
    aSystem, // ICD-10 Remediation. ROR*1.5*19 2012-01-09 ====================
    aName: String;
    dummy: String;
  begin
    params := TReportParameters(aList);
    with ccrOtherDiagSelector180.ResultTree do
      begin
        // Leave the "dummy := params.Text" line in even though it does nothing.
        // When it is removed, an access violation frequently occurs on the line
        // where GetAttrStr is used.
        dummy := params.Text;
        aName := params.GetAttrStr(srcGroup, 'ID');
        if aName <> '' then
          begin
            Result := FindGroup(aName);
            if not Assigned(Result) then
              Result := AddGroup(aName);
          end
        else
          Result := nil;
        if Assigned(Result) then
          begin
            DeleteChildren(Result);
            empty := True;
            srcItem := srcGroup.FirstChild;
            while Assigned(srcItem) do
              begin
                aName := params.GetNodeVal(srcItem);
                if aName <> '' then
                  begin
// ID-10 Remediation. ROR*1.5*19 2012-01-24 =================================[
                    aSystem := params.GetAttrStr(srcItem,nxml_VERSION);
//                    dstItem := AddItem(Result, aName, params.GetAttrStr(srcItem,'ID'));
                    dstItem := AddItem(Result, aSystem, aName, params.GetAttrStr(srcItem,'ID'));
// ID-10 Remediation. ROR*1.5*19 2012-01-13 =================================]
                    empty := False;
                  end;
                srcItem := srcItem.NextSibling;
              end;
            if empty then
              begin
                DeleteGroup(Result);
                Result := nil;
              end;
          end;
      end;
  end;

var
  srcGroup: TDomNode;
  params: TReportParameters;
  empty: Boolean;
  node: TDomNode;
begin
  params := TReportParameters(aList);
  with ccrOtherDiagSelector180 do
  begin
    ResultTree.BeginUpdate;
    try
//      node := params.FindNode('/PARAMS/ICD9FILT'); // ICD-10 Remediation. ROR*1.5*19 2012-01-10
      node := params.FindNode(nxml_PARAMS_ICDFILT);  // ICD-10 Remediation. ROR*1.5*19 2012-01-10
      if Assigned(node) and (params.GetAttrStr(node, 'FILTER') <> 'ALL') then
      begin
        empty := True;
        srcGroup := node.FirstChild;
        while Assigned(srcGroup) do
        begin
          if group(srcGroup) <> nil then
            empty := False;
          srcGroup := srcGroup.NextSibling;
        end;
        if not empty then
        begin
          if (params.GetAttrStr(node, 'FILTER') = 'INCLUDE') then
            rbInclude180.Checked := True
          else if (params.GetAttrStr(node, 'FILTER') = 'EXCLUDE') then
            rbExclude180.Checked := True;
        end
        //  ICD-10: CodeCR CCR189 ---------------------------------------- begin
        //          The empty template will clear the Source list,
        //          thus an attmpt to process the next item of the Source list
        //          ignites the access violation exception
        //          and the rest of the template list is not processed.
        //          The next 2 lines were commented out to fix this issue
        //  else
        //    Clear;
        ;// ICD-10. CodeCR CCR189 ------------------------------------------ end
      end
      else
        rbIgnore180.Checked := True; // This also clears the selector
    finally
      ResultTree.EndUpdate;
    end;
    ResultChanged := False;
  end;
end;

procedure TFrameReportParameters.rbIgnore180Click(Sender: TObject);
begin
  rbAllClick(Sender);
  cmbxOtherDiagSearch180.ItemIndex := 0;
end;

procedure TFrameReportParameters.cmbxOtherDiagSearch180Select(
  Sender: TObject);
begin
  if cmbxOtherDiagSearch180.ItemIndex <> dirNone then
    loadOtherDiagList;
end;

procedure TFrameReportParameters.loadOtherDiagList;
begin
  Screen.Cursor := crHourGlass;
  try
    Broker.CreateResults;
    //--- Clear the list of template names
    ccrOtherDiagSelector180.SourceList.Clear;
    //--- Load the list of template names
    if Broker.CallProc('ROR LIST PARAMETER INSTANCES',
       [sReportParamsTemplate, ICD9FilterType, '13::']) then
    begin
      ccrOtherDiagSelector180.SourceList.Items.BeginUpdate;
      try
        //--- Add the records to the list
        Broker.Results.Delete(0);
        ccrOtherDiagSelector180.SourceList.Items.AppendRawData(Broker.Results, [-99,1], U, 1);
      finally
        ccrOtherDiagSelector180.SourceList.Items.EndUpdate;
      end;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFrameReportParameters.ccrOtherDiagSelector180Add(Sender: TObject);
var i: integer;
  rpcParam1: string;
  params: TReportParameters;
  rawData: TStringList;
  iPos: Integer;
begin
  params := TReportParameters.Create;
  rawData := TStringList.Create;
  try
    for i := 0 to ccrOtherDiagSelector180.SourceList.Items.Count-1 do
    begin
      if ccrOtherDiagSelector180.SourceList.Items[i].Selected then
      begin
        rpcParam1 := '13::'
          + ccrOtherDiagSelector180.SourceList.Items[i].AsString[idscName]
          + U + sReportParamsTemplate;
        rawData.Clear;
        if Broker.CallProc(rpcGUIParameterGet, [rpcParam1, ICD9FilterType], nil, rawData) then
        begin
          rawData.Delete(0);
          rawData.Text := FixTemplateFormat(rawData.Text,'13::'); // ROR*1.5*19 Fixing template format
          params.Assign(rawData);
          pnlParams180.SetFieldValues('', params);
        end;
      end;
    end;
    ccrOtherDiagSelector180.SourceList.DeleteSelected;
  finally
    rawData.Free;
    params.Free;
  end;
end;

procedure TFrameReportParameters.ccrOtherDiagSelector180AddAll(Sender: TObject);
begin
  ccrOtherDiagSelector180.SourceList.SelectAll;
  ccrOtherDiagSelector180Add(Sender);
end;

procedure TFrameReportParameters.ccrOtherDiagSelector180Remove(Sender: TObject);
begin
  ccrOtherDiagSelector180.ResultTree.DeleteSelectedNodes;
end;

procedure TFrameReportParameters.ccrOtherDiagSelector180RemoveAll(
  Sender: TObject);
begin
  ccrOtherDiagSelector180.ResultTree.Clear;
  ccrOtherDiagSelector180.ResultTree.AddGroup('Diagnoses');
end;

procedure TFrameReportParameters.acOtherDiagGroupDeleteExecute(Sender: TObject);
begin
  deleteResultTreeGroup(ccrOtherDiagSelector180.ResultTree);
end;

procedure TFrameReportParameters.ccrOtherDiagSelector180ResultListKeyAction(
  Sender: TBaseVirtualTree; var CharCode: Word; var Shift: TShiftState;
  var DoDefault: Boolean);
begin
  if (Shift = []) and (CharCode = VK_DELETE) then
  begin
    deleteResultTreeGroup(ccrOtherDiagSelector180.ResultTree);
    DoDefault := False;
  end;
end;
{$ENDREGION}

{$REGION ' Panel 201 - BMI/Liver/Renal Date Range '}
///////////////////////////// Parameters Panel #201 \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameReportParameters.pnlParams201Setup(const aReportCode: string);
var tmpLab: TLabel;
begin
  if (aReportCode = '18') then
  begin
     pnlParams201.Caption := 'BMI Date Range';
     rbRangeMostRecent.Caption := 'Most recent BMI';
     rbRangeMax.Caption := 'BMI as of';
  end
  else if (aReportCode = '19') then
  begin
     pnlParams201.Caption := 'Liver Score Date Range';
     rbRangeMostRecent.Caption := 'Most recent Liver score';
     rbRangeMax.Caption := 'Liver Score as of';
  end
  else if (aReportCode = '20') then
  begin
     pnlParams201.Caption := 'Renal Function Date Range';
     rbRangeMostRecent.Caption := 'Most recent renal function';
     rbRangeMax.Caption := 'Renal function as of';
  end;
  //Calculate the size of the radio button text so we can position them properly
  tmpLab := TLabel.Create(pnlParams201);
  tmpLab.AutoSize := true;
  tmpLab.Font := rbRangeMostRecent.Font;
  tmpLab.Caption := rbRangeMostRecent.Caption;
  rbRangeMostRecent.Width := tmpLab.Width + 22;
  tmpLab.Font := rbRangeMax.Font;
  tmpLab.Caption := rbRangeMax.Caption;
  rbRangeMax.Width := tmpLab.Width + 22;
  rbRangeMax.Left := rbRangeMostRecent.Left + rbRangeMostRecent.Width + 40;
  dtpRangeMaxDate.Left := rbRangeMax.Left + rbRangeMax.Width + 2;
  tmpLab.Destroy;
end;

procedure TFrameReportParameters.pnlParams201GetValues(
  const aReportCode: string; aList: TCustomReportParameters; aMsgLst: TStrings;
  var aField: TWinControl);
var
  dateMax: Double;
begin
  with TReportParameters(aList) do
  begin
    SetAttrVal(NodeOptions, 'MOST_RECENT', rbRangeMostRecent.Checked);
    if rbRangeMax.Checked then
    begin
      dateMax := WindowsDateToFMDate(Trunc(dtpRangeMaxDate.Date));
      SetAttrVal(NodeOptions, 'MAX_DATE', FloatToStr(dateMax));
    end
    else begin
      SetAttrVal(NodeOptions, 'MOST_RECENT', rbRangeMostRecent.Checked);
      SetAttrVal(NodeOptions, 'MAX_DATE', '');
    end;
  end;
  if not (rbRangeMostRecent.Checked or rbRangeMax.Checked) then
  begin
    aMsgLst.Add(RSC00227);
    aField := rbRangeMostRecent;
  end;
end;

procedure TFrameReportParameters.pnlParams201SetValues(
  const aReportCode: string; aList: TCustomReportParameters);
var
  maxDate: integer;
begin
  with TReportParameters(aList) do
  begin
    rbRangeMostRecent.Checked := GetAttrBool(NodeOptions, 'MOST_RECENT');
    if not rbRangeMostRecent.Checked then
    begin
      rbRangeMax.Checked := true;
      try
        maxDate := GetAttrInt(NodeOptions, 'MAX_DATE');
        if maxDate = 0 then
          dtpRangeMaxDate.Date := Date
        else
          dtpRangeMaxDate.Date := FMDateTimeToWindowsDateTime(maxDate);
      except
        dtpRangeMaxDate.Date := Date;
      end;

    end;
  end;
end;

procedure TFrameReportParameters.rbToggleDateEntry(Sender: TObject);
begin
  dtpRangeMaxDate.Enabled := (Sender = rbRangeMax);
  dtpRangeMaxDate.Color := CtrlColor(dtpRangeMaxDate.Enabled);
end;
{$ENDREGION}

end.

